/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.component.spring;

import de.intarsys.component.spring.Pkcs11Properties;
import de.intarsys.security.device.pkcs11.ModuleRegistry;
import de.intarsys.security.device.pkcs11.Pkcs11Exception;
import de.intarsys.security.device.pkcs11.device.Pkcs11DeviceProvider;
import java.nio.file.Path;
import java.util.Map;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={Pkcs11Properties.class})
public class Pkcs11DeviceConfiguration {
    @Bean
    public ModuleRegistry moduleRegistry(Pkcs11Properties properties) throws Pkcs11Exception {
        ModuleRegistry registry = new ModuleRegistry();
        if (properties.modules() != null) {
            for (Map.Entry<String, Path> entry : properties.modules().entrySet()) {
                registry.registerModule(entry.getKey(), entry.getValue());
            }
        }
        return registry;
    }

    @Bean(value={"deviceProvider.pkcs11"})
    public Pkcs11DeviceProvider pkcs11DeviceProvider() {
        return new Pkcs11DeviceProvider();
    }
}

