/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pkcs11;

import de.intarsys.security.device.pkcs11.Pkcs11Exception;
import iaik.pkcs.pkcs11.DefaultInitializeArgs;
import iaik.pkcs.pkcs11.InitializeArgs;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.TokenException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleRegistry {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Object lock = new Object();
    private Map<Path, String> namesByPath = new HashMap<Path, String>();
    private Map<String, Path> pathsByName = new HashMap<String, Path>();
    private Map<String, Module> modulesByName = new HashMap<String, Module>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerModule(String name, Path path) throws Pkcs11Exception {
        if (path.getNameCount() > 1) {
            path = path.toAbsolutePath().normalize();
        }
        Object object = this.lock;
        synchronized (object) {
            String oldName = this.namesByPath.get(path);
            if (oldName != null) {
                throw new Pkcs11Exception(String.format("Path %s is already registered as PKCS#11 module %s", path, name));
            }
            Path oldPath = this.pathsByName.get(name);
            if (oldPath != null) {
                throw new Pkcs11Exception(String.format("PKCS#11 module %s already registered with path %s", name, path));
            }
            this.namesByPath.put(path, name);
            this.pathsByName.put(name, path);
            this.logger.info("Registered PKCS#11 module {} -> {}", (Object)name, (Object)path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterModule(String name) {
        Object object = this.lock;
        synchronized (object) {
            Path path = this.pathsByName.remove(name);
            if (path == null) {
                return;
            }
            this.namesByPath.remove(path);
            Module module = this.modulesByName.remove(name);
            if (module != null) {
                try {
                    module.finalize(null);
                    this.logger.info("Finalized PKCS#11 module {}", (Object)name);
                }
                catch (TokenException exception) {
                    this.logger.error("Failed to finalize PKCS#11 module {}", (Object)name, (Object)exception);
                }
            }
            this.logger.info("Unregistered PKCS#11 module {}", (Object)name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Module getModule(String name) throws Pkcs11Exception {
        Object object = this.lock;
        synchronized (object) {
            Module module = this.modulesByName.get(name);
            if (module == null) {
                module = this.loadModule(name);
                this.modulesByName.put(name, module);
            }
            return module;
        }
    }

    private Module loadModule(String name) throws Pkcs11Exception {
        Path path = this.pathsByName.get(name);
        if (path == null) {
            throw new Pkcs11Exception(String.format("Unknown PKCS#11 module %s", name));
        }
        try {
            Module module = Module.getInstance((String)path.toString());
            this.logger.debug("Loaded PKCS#11 module {} -> {}", (Object)name, (Object)path);
            DefaultInitializeArgs initializeArgs = new DefaultInitializeArgs();
            initializeArgs.setOsLockingOk(false);
            module.initialize((InitializeArgs)initializeArgs);
            this.logger.info("Initialized PKCS#11 module {}", (Object)name);
            return module;
        }
        catch (TokenException | IOException exception) {
            throw new Pkcs11Exception(String.format("Failed to connect to or initialize PKCS#11 module %s (%s)", name, path));
        }
    }
}

