/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pkcs11.app;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.pkcs11.Pkcs11Exception;
import de.intarsys.security.device.pkcs11.app.CertifiedPrivateKey;
import de.intarsys.security.device.pkcs11.app.PACKAGE;
import de.intarsys.security.device.pkcs11.app.SignerIdentifier;
import de.intarsys.security.device.pkcs11.device.Pkcs11Device;
import de.intarsys.security.device.pkcs11.util.Pkcs11Tools;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class CertificateFilterSignerIdentifier
implements SignerIdentifier {
    private static final int MAX_OBJECT_COUNT = 10;
    private Predicate<IX509Certificate> certificateFilter;

    public CertificateFilterSignerIdentifier(Predicate<IX509Certificate> certificateFilter) {
        this.certificateFilter = certificateFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CertifiedPrivateKey findPrivateKey(Pkcs11Device device) throws Pkcs11Exception {
        Session session = device.acquireSession();
        try {
            CertifiedPrivateKey certifiedPrivateKey = this.findPrivateKey(session);
            return certifiedPrivateKey;
        }
        finally {
            device.releaseSession(session);
        }
    }

    private CertifiedPrivateKey findPrivateKey(Session session) throws Pkcs11Exception {
        List<X509PublicKeyCertificate> candidates = this.findCertificates(session, this.createCertificateTemplate());
        for (X509PublicKeyCertificate candidate : candidates) {
            PrivateKey privateKey;
            IX509PublicKeyCertificate certificate = Pkcs11Tools.toIX509PublicKeyCertificate(candidate);
            if (!this.certificateFilter.test((IX509Certificate)certificate) || (privateKey = this.findPrivateKeyById(session, candidate.getId())) == null) continue;
            return new CertifiedPrivateKey(privateKey, certificate);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<X509PublicKeyCertificate> findCertificates(Session session, X509PublicKeyCertificate template) throws Pkcs11Exception {
        ArrayList<X509PublicKeyCertificate> certificates = new ArrayList<X509PublicKeyCertificate>();
        try {
            session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)template);
            try {
                iaik.pkcs.pkcs11.objects.Object[] objects;
                do {
                    for (iaik.pkcs.pkcs11.objects.Object object : objects = session.findObjects(10)) {
                        certificates.add((X509PublicKeyCertificate)object);
                    }
                } while (objects.length > 0);
            }
            finally {
                session.findObjectsFinal();
            }
        }
        catch (TokenException exception) {
            throw new Pkcs11Exception(PACKAGE.Messages.getString("CertificateFilterSignerIdentifier.failedToFindCertificate", new Object[0]), exception);
        }
        return certificates;
    }

    private X509PublicKeyCertificate createCertificateTemplate() {
        return new X509PublicKeyCertificate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey findPrivateKeyById(Session session, ByteArrayAttribute id) throws Pkcs11Exception {
        PrivateKey privateKey;
        PrivateKey template = new PrivateKey();
        template.getSign().setValue((Object)true);
        template.getId().setByteArrayValue(id.getByteArrayValue());
        session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)template);
        try {
            iaik.pkcs.pkcs11.objects.Object[] objects = session.findObjects(1);
            privateKey = objects.length > 0 ? (PrivateKey)objects[0] : null;
        }
        catch (Throwable throwable) {
            try {
                session.findObjectsFinal();
                throw throwable;
            }
            catch (TokenException exception) {
                throw new Pkcs11Exception(PACKAGE.Messages.getString("CertificateFilterSignerIdentifier.failedToFindPrivateKey", new Object[0]), exception);
            }
        }
        session.findObjectsFinal();
        return privateKey;
    }
}

