/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pkcs11.app;

import de.intarsys.security.algorithm.common.EncryptionAlgorithm;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.pkcs11.app.Pkcs11Signer;
import de.intarsys.security.device.pkcs11.device.Pkcs11Device;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.exception.UnreachableCodeError;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;

public class Pkcs11EcSigner
extends Pkcs11Signer {
    public Pkcs11EcSigner(Pkcs11Device device, PrivateKey privateKey, IX509PublicKeyCertificate certificate) {
        super(device, EncryptionAlgorithm.ALG_EC, privateKey, certificate);
    }

    @Override
    protected byte[] sign(Session session, PrivateKey privateKey, IDigest digest) throws IOException, TokenException {
        Mechanism mechanism = Mechanism.get((long)4161L);
        session.signInit(mechanism, (Key)privateKey);
        byte[] signature = session.sign(digest.getBytes());
        return this.encodeEcdsaSigValue(signature);
    }

    private byte[] encodeEcdsaSigValue(byte[] signature) {
        if (signature.length % 2 != 0) {
            throw new IllegalArgumentException("signature.length is odd, but must be even!");
        }
        byte[] r = Arrays.copyOfRange(signature, 0, signature.length / 2);
        byte[] s = Arrays.copyOfRange(signature, signature.length / 2, signature.length);
        try {
            return this.derSequence(new ASN1Encodable[]{this.asn1Integer(r), this.asn1Integer(s)}).getEncoded();
        }
        catch (IOException exception) {
            throw new UnreachableCodeError((Throwable)exception);
        }
    }

    private ASN1Integer asn1Integer(byte[] magnitude) {
        return new ASN1Integer(new BigInteger(1, magnitude));
    }

    private DERSequence derSequence(ASN1Encodable ... encodables) {
        return new DERSequence(encodables);
    }
}

