/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pkcs11.app;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.EncryptionAlgorithm;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.pkcs11.app.Pkcs11Signer;
import de.intarsys.security.device.pkcs11.device.Pkcs11Device;
import de.intarsys.tools.digest.IDigest;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.RSAPkcsPssParameters;
import java.io.IOException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

public class Pkcs11RsaPssSigner
extends Pkcs11Signer {
    public Pkcs11RsaPssSigner(Pkcs11Device device, PrivateKey privateKey, IX509PublicKeyCertificate certificate) {
        super(device, EncryptionAlgorithm.ALG_RSA, privateKey, certificate);
    }

    @Override
    protected void initializeAlgorithmParameterSpec(String hashAlgorithmName) {
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.lookupAlgorithm((String)hashAlgorithmName);
        if (digestAlgorithm != null) {
            this.setAlgorithmParameterSpec(new PSSParameterSpec(digestAlgorithm.getName(), "MGF1", new MGF1ParameterSpec(digestAlgorithm.getName()), digestAlgorithm.getSize(), 1));
        }
    }

    @Override
    protected byte[] sign(Session session, PrivateKey privateKey, IDigest digest) throws IOException, TokenException {
        Mechanism mechanism = this.createMechanism(digest.getAlgorithmName());
        session.signInit(mechanism, (Key)privateKey);
        return session.sign(digest.getBytes());
    }

    private Mechanism createMechanism(String algorithmName) {
        return switch (algorithmName) {
            case "SHA-1" -> this.createMechanism(544L, 1L, 160L);
            case "SHA-224" -> this.createMechanism(597L, 5L, 224L);
            case "SHA-256" -> this.createMechanism(592L, 2L, 256L);
            case "SHA-384" -> this.createMechanism(608L, 3L, 384L);
            case "SHA-512" -> this.createMechanism(624L, 4L, 512L);
            case "SHA3-224" -> this.createMechanism(693L, 6L, 224L);
            case "SHA3-256" -> this.createMechanism(688L, 7L, 256L);
            case "SHA3-384" -> this.createMechanism(704L, 8L, 384L);
            case "SHA3-512" -> this.createMechanism(720L, 9L, 512L);
            default -> throw new IllegalArgumentException("Unsupported hash algorithm: " + algorithmName);
        };
    }

    private Mechanism createMechanism(long mechanismCode, long maskGenerationFunction, long saltBitLength) {
        Mechanism mechanism = new Mechanism(13L);
        mechanism.setParameters((Parameters)new RSAPkcsPssParameters(new Mechanism(mechanismCode), maskGenerationFunction, saltBitLength / 8L));
        return mechanism;
    }
}

