/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pkcs11.app;

import de.intarsys.security.algorithm.common.EncryptionAlgorithm;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.CommonSingleSigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.pkcs11.Pkcs11Exception;
import de.intarsys.security.device.pkcs11.app.PACKAGE;
import de.intarsys.security.device.pkcs11.device.Pkcs11Device;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.digest.IDigest;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public abstract class Pkcs11Signer
extends CommonSingleSigner {
    private static final List<String> SUPPORTED_HASH_ALGORITHM_NAMES = List.of("SHA-1", "SHA-224", "SHA-256", "SHA-384", "SHA-512", "SHA3-224", "SHA3-256", "SHA3-384", "SHA3-512");
    private PrivateKey privateKey;
    private EncryptionAlgorithm encryptionAlgorithm;

    protected Pkcs11Signer(Pkcs11Device device, EncryptionAlgorithm encryptionAlgorithm, PrivateKey privateKey, IX509PublicKeyCertificate certificate) {
        super((CommonDevice)device);
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.privateKey = privateKey;
        this.setCertificatePath(new IX509PublicKeyCertificate[]{certificate});
    }

    public boolean isBasic() {
        return true;
    }

    public Collection<String> getSupportedHashAlgorithmNames() {
        return SUPPORTED_HASH_ALGORITHM_NAMES;
    }

    public String getEncryptionAlgorithmName() {
        return this.encryptionAlgorithm.getName();
    }

    public void setHashAlgorithmName(String hashAlgorithmName) throws SecurityApplicationException {
        super.setHashAlgorithmName(hashAlgorithmName);
        this.initializeAlgorithmParameterSpec(hashAlgorithmName);
    }

    protected void initializeAlgorithmParameterSpec(String hashAlgorithmName) {
    }

    protected Pkcs11Device basicGetDevice() {
        return (Pkcs11Device)super.basicGetDevice();
    }

    protected IConversation<ISignatureData> basicSignSingle(IToBeSignedData data) {
        IConversation iConversation;
        IDigest digest = data.getDigest();
        this.initializeAlgorithmParameterSpec(digest.getAlgorithmName());
        Session session = this.basicGetDevice().acquireSession();
        try {
            byte[] signature = this.sign(session, this.privateKey, digest);
            iConversation = Conversation.completed((Object)SignatureData.create((byte[])signature));
        }
        catch (TokenException | IOException exception) {
            try {
                try {
                    throw new Pkcs11Exception(PACKAGE.Messages.getString("Pkcs11Signer.signatureCreationFailed", new Object[0]), exception);
                }
                catch (Throwable throwable) {
                    this.basicGetDevice().releaseSession(session);
                    throw throwable;
                }
            }
            catch (Pkcs11Exception exception2) {
                return Conversation.failed((Throwable)exception2);
            }
        }
        this.basicGetDevice().releaseSession(session);
        return iConversation;
    }

    protected abstract byte[] sign(Session var1, PrivateKey var2, IDigest var3) throws IOException, TokenException;
}

