/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pkcs11.app;

import de.intarsys.security.app.signature.CommonSignerFactory;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.CertificateFilterTools;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.device.pkcs11.Pkcs11Exception;
import de.intarsys.security.device.pkcs11.app.CertificateFilterSignerIdentifier;
import de.intarsys.security.device.pkcs11.app.CertifiedPrivateKey;
import de.intarsys.security.device.pkcs11.app.PACKAGE;
import de.intarsys.security.device.pkcs11.app.Pkcs11EcSigner;
import de.intarsys.security.device.pkcs11.app.Pkcs11RsaPssSigner;
import de.intarsys.security.device.pkcs11.app.Pkcs11RsaSigner;
import de.intarsys.security.device.pkcs11.app.Pkcs11Signer;
import de.intarsys.security.device.pkcs11.app.RsaSignatureEncoding;
import de.intarsys.security.device.pkcs11.app.SignerIdentifier;
import de.intarsys.security.device.pkcs11.device.Pkcs11Device;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import iaik.pkcs.pkcs11.objects.ECDSAPrivateKey;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import java.util.function.Predicate;

public class Pkcs11SignerFactory
extends CommonSignerFactory<Pkcs11Device, Pkcs11Signer> {
    public static final String ARG_RSA_SIGNATURE_ENCODING = "rsaSignatureEncoding";
    public static final RsaSignatureEncoding DEFAULT_RSA_SIGNATURE_ENCODING = RsaSignatureEncoding.RSA;

    protected Pkcs11Signer basicCreateApp(IArgs args) throws ObjectCreationException {
        Pkcs11Device device = (Pkcs11Device)this.getDevice(args);
        CertifiedPrivateKey certifiedPrivateKey = this.findPrivateKey(device, args);
        PrivateKey key = certifiedPrivateKey.privateKey();
        IX509PublicKeyCertificate certificate = certifiedPrivateKey.certificate();
        if (key instanceof RSAPrivateKey) {
            return this.getRsaSignatureEncoding(args) == RsaSignatureEncoding.RSAPSS ? new Pkcs11RsaPssSigner(device, key, certificate) : new Pkcs11RsaSigner(device, key, certificate);
        }
        if (key instanceof ECDSAPrivateKey) {
            return new Pkcs11EcSigner(device, key, certificate);
        }
        throw new ObjectCreationException(PACKAGE.Messages.getString("Pkcs11SignerFactory.unsupportedPrivateKeyType", new Object[0]));
    }

    private CertifiedPrivateKey findPrivateKey(Pkcs11Device device, IArgs args) throws ObjectCreationException {
        CertifiedPrivateKey certifiedPrivateKey;
        try {
            certifiedPrivateKey = this.getSignerIdentifier(args).findPrivateKey(device);
        }
        catch (Pkcs11Exception exception) {
            throw new ObjectCreationException(PACKAGE.Messages.getString("Pkcs11SignerFactory.failedToLookUpPrivateKey", new Object[0]), (Throwable)exception);
        }
        if (certifiedPrivateKey == null) {
            throw new ObjectCreationException(PACKAGE.Messages.getString("Pkcs11SignerFactory.privateKeyNotFound", new Object[0]));
        }
        if (certifiedPrivateKey.certificate() == null) {
            throw new ObjectCreationException(PACKAGE.Messages.getString("Pkcs11SignerFactory.certificateNotFound", new Object[0]));
        }
        return certifiedPrivateKey;
    }

    private SignerIdentifier getSignerIdentifier(IArgs args) throws ObjectCreationException {
        Object object = ArgTools.getObject((IArgs)args, (String)"signerIdentifier", null);
        IX509CertificateFilter certificateFilter = CertificateFilterTools.createCertificateFilter((Object)object);
        return new CertificateFilterSignerIdentifier((Predicate<IX509Certificate>)(certificateFilter == null ? c -> true : certificateFilter));
    }

    private RsaSignatureEncoding getRsaSignatureEncoding(IArgs args) {
        String name = ArgTools.getString((IArgs)args, (String)ARG_RSA_SIGNATURE_ENCODING, null);
        return name == null ? DEFAULT_RSA_SIGNATURE_ENCODING : RsaSignatureEncoding.fromName(name);
    }

    public Class<Pkcs11Signer> getResultType() {
        return Pkcs11Signer.class;
    }
}

