/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pkcs11.device;

import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.pkcs11.Pkcs11Exception;
import de.intarsys.security.device.pkcs11.device.PACKAGE;
import de.intarsys.security.device.pkcs11.device.Pkcs11DeviceProvider;
import de.intarsys.security.device.pkcs11.util.Pkcs11Tools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import java.security.GeneralSecurityException;

public class Pkcs11Device
extends CommonDevice<Pkcs11DeviceProvider> {
    public static final String ARG_MODULE = "module";
    public static final String ARG_SLOT = "slot";
    public static final String ARG_TOKEN_LABEL = "tokenLabel";
    public static final String ARG_USER_PIN = "userPin";
    private String moduleName;
    private Slot slot;
    private Session session;
    private int sessionReferenceCount = 0;
    private Secret userPin;
    private Object sessionLock = new Object();

    public Pkcs11Device(Pkcs11DeviceProvider deviceProvider, String id) {
        super((CommonDeviceProvider)deviceProvider, id);
    }

    public void configure(IArgs args) throws Exception {
        this.userPin = ArgTools.getSecretHide((IArgs)args, (String)ARG_USER_PIN, (Secret)Secret.EMPTY);
        this.slot = this.resolveSlot(args);
    }

    private Slot resolveSlot(IArgs args) throws Pkcs11Exception {
        this.moduleName = ArgTools.getString((IArgs)args, (String)ARG_MODULE, null);
        if (this.moduleName == null) {
            throw ExceptionTools.argumentRequired((String)ARG_MODULE);
        }
        Module module = ((Pkcs11DeviceProvider)this.getDeviceProvider()).getModule(this.moduleName);
        String tokenLabel = ArgTools.getString((IArgs)args, (String)ARG_TOKEN_LABEL, null);
        if (tokenLabel != null && !tokenLabel.isEmpty()) {
            return this.getSlotByTokenLabel(module, tokenLabel);
        }
        long slotId = ArgTools.getLong((IArgs)args, (String)ARG_SLOT, (long)-1L);
        if (slotId != -1L) {
            return this.getSlotById(module, slotId);
        }
        throw new IllegalArgumentException(String.format("Argument %s or %s required", ARG_TOKEN_LABEL, ARG_SLOT));
    }

    private Slot getSlotById(Module module, long slotId) throws Pkcs11Exception {
        try {
            for (Slot candidate : module.getSlotList(false)) {
                if (candidate.getSlotID() != slotId) continue;
                return candidate;
            }
        }
        catch (TokenException exception) {
            throw new Pkcs11Exception(PACKAGE.Messages.getString("Pkcs11Device.failedToQuerySlots", new Object[0]), exception);
        }
        throw new Pkcs11Exception(PACKAGE.Messages.getString("Pkcs11Device.slotNotFound", new Object[]{slotId}));
    }

    private Slot getSlotByTokenLabel(Module module, String tokenLabel) throws Pkcs11Exception {
        try {
            for (Slot candidate : module.getSlotList(true)) {
                Token token = candidate.getToken();
                if (token == null || !tokenLabel.equals(Pkcs11Tools.getLabel(token))) continue;
                return candidate;
            }
        }
        catch (TokenException exception) {
            throw new Pkcs11Exception(PACKAGE.Messages.getString("Pkcs11Device.failedToQuerySlots", new Object[0]), exception);
        }
        throw new Pkcs11Exception(PACKAGE.Messages.getString("Pkcs11Device.tokenNotFound", new Object[]{tokenLabel}));
    }

    protected void logConfiguration() {
        super.logConfiguration();
        this.logger.info("  +-- module: {}", (Object)this.moduleName);
        if (this.slot != null) {
            String tokenLabel;
            try {
                tokenLabel = Pkcs11Tools.getLabel(this.slot.getToken());
            }
            catch (TokenException exception) {
                tokenLabel = "(not present)";
            }
            this.logger.info("  +-- slot: {}", (Object)this.slot.getSlotID());
            this.logger.info("  +-- token: {}", (Object)tokenLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session acquireSession() throws Pkcs11Exception {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.session == null) {
                this.session = this.openSession();
                this.logIn(this.session);
            }
            ++this.sessionReferenceCount;
            this.logger.trace("session {} acquired (now {} references)", (Object)this.session.getSessionHandle(), (Object)this.sessionReferenceCount);
            return this.session;
        }
    }

    private Session openSession() throws Pkcs11Exception {
        try {
            Token token = this.slot.getToken();
            if (token == null) {
                throw new Pkcs11Exception(PACKAGE.Messages.getString("Pkcs11Device.noTokenPresent", new Object[0]));
            }
            return token.openSession(true, false, null, null);
        }
        catch (TokenException exception) {
            throw new Pkcs11Exception(PACKAGE.Messages.getString("Pkcs11Device.failedToOpenSession", new Object[0]), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSession(Session session) throws Pkcs11Exception {
        Object object = this.sessionLock;
        synchronized (object) {
            if (session == this.session && this.sessionReferenceCount > 0) {
                --this.sessionReferenceCount;
            }
            this.logger.trace("session {} released (now {} references)", (Object)session.getSessionHandle(), (Object)this.sessionReferenceCount);
        }
    }

    private void closeSession() throws Pkcs11Exception {
        if (this.session != null) {
            try {
                this.logger.trace("closing session {}", (Object)this.session.getSessionHandle());
                this.session.closeSession();
            }
            catch (TokenException exception) {
                throw new Pkcs11Exception(PACKAGE.Messages.getString("Pkcs11Device.failedToCloseSession", new Object[0]), exception);
            }
            finally {
                this.session = null;
            }
        }
    }

    private void logIn(Session session) throws Pkcs11Exception {
        try {
            this.logger.trace("logging user in for session {}", (Object)session.getSessionHandle());
            session.login(true, this.userPin.getChars());
        }
        catch (TokenException | GeneralSecurityException exception) {
            throw new Pkcs11Exception(PACKAGE.Messages.getString("Pkcs11Device.failedToLogUserIn", new Object[0]), exception);
        }
    }
}

