/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pkcs11.device;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.signature.CommonSignerPolicy;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.pkcs11.ModuleRegistry;
import de.intarsys.security.device.pkcs11.Pkcs11Exception;
import de.intarsys.security.device.pkcs11.app.Pkcs11SignerFactory;
import de.intarsys.security.device.pkcs11.device.Pkcs11Device;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import iaik.pkcs.pkcs11.Module;
import jakarta.annotation.PostConstruct;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class Pkcs11DeviceProvider
extends CommonDeviceProvider<Pkcs11Device> {
    private static final String LIC_PRODUCT = "de.intarsys.security.device.pkcs11";
    private ModuleRegistry moduleRegistry;

    public Pkcs11DeviceProvider() {
        super("pkcs11");
    }

    @Autowired
    public void setModuleRegistry(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
    }

    public Module getModule(String name) throws Pkcs11Exception {
        return this.moduleRegistry.getModule(name);
    }

    @PostConstruct
    public void init() {
        super.init();
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
    }

    protected Pkcs11Device basicCreateInstance(IArgs args) throws ObjectCreationException {
        return new Pkcs11Device(this, this.getId(args));
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> apps) {
        super.declareApplicationDescriptors(apps);
        Pkcs11SignerFactory signerFactory = new Pkcs11SignerFactory();
        signerFactory.setDeviceProvider(this);
        signerFactory.setLicenseAccountSupplier(() -> this.declareLicenseAccountSign());
        signerFactory.setPolicy((IApplicationPolicy)new CommonSignerPolicy((CommonDeviceProvider)this));
        signerFactory.setType(ISigner.class);
        apps.add((IApplicationDescriptor)signerFactory);
    }

    protected ILicenseAccount declareLicenseAccountSignBasic() {
        ILicenseAccount account = this.getLicenseProduct().getAccount("de.intarsys.security.app.sign.account");
        account.setDefaultValueUnit(10, LicensePropertyUnit.PER_MINUTE);
        return account;
    }

    protected LicenseProduct declareLicenseProduct() {
        return LicenseTools.createProduct((Object)((Object)this), (String)LIC_PRODUCT);
    }
}

