/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pkcs11.util;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.device.pkcs11.Pkcs11Exception;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import java.security.cert.CertificateException;

public class Pkcs11Tools {
    public static String getLabel(Token token) throws TokenException {
        return token.getTokenInfo().getLabel().trim();
    }

    public static IX509PublicKeyCertificate toIX509PublicKeyCertificate(X509PublicKeyCertificate certificate) throws Pkcs11Exception {
        byte[] bytes = certificate.getValue().getByteArrayValue();
        try {
            return X509CertificateFactory.get().createPublicKeyCertificate(bytes);
        }
        catch (CertificateException exception) {
            throw new Pkcs11Exception("Invalid certificate", exception);
        }
    }

    private Pkcs11Tools() {
    }
}

