/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.CommonFontStore;
import de.intarsys.cwt.font.IFontRegistry;
import de.intarsys.cwt.font.IProviderBasedFontStore;
import de.intarsys.cwt.freetype.Library;
import de.intarsys.os.linux_gtk.fontconfig.FontSet;
import de.intarsys.os.linux_gtk.fontconfig.Fontconfig;
import de.intarsys.os.linux_gtk.fontconfig.ObjectSet;
import de.intarsys.os.linux_gtk.fontconfig.Pattern;
import de.intarsys.tools.system.SystemTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontconfigFontStore
extends CommonFontStore
implements IProviderBasedFontStore {
    private static final Logger Log = LoggerFactory.getLogger(FontconfigFontStore.class);

    public boolean isSupported() {
        return SystemTools.isLinux();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Library library, IFontRegistry fontRegistry, Object logPrefix) {
        Log.debug("{} load system fonts from Fontconfig", logPrefix);
        Pattern pattern = Fontconfig.patternCreate();
        pattern.add("outline", true);
        try {
            ObjectSet objectSet = Fontconfig.objectSetCreate();
            objectSet.add("file");
            try {
                FontSet fontSet = Fontconfig.fontList((Pattern)pattern, (ObjectSet)objectSet);
                try {
                    fontSet.getFonts().stream().map(font -> font.getString("file")).forEach(fileName -> this.loadFontUnchecked(library, fontRegistry, logPrefix, (String)fileName));
                }
                finally {
                    fontSet.destroy();
                }
            }
            finally {
                objectSet.destroy();
            }
        }
        finally {
            pattern.destroy();
        }
    }
}

