/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.requestmeta.model;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.atomic.AtomicInteger;

public class RequestMetaData {
    private static AtomicInteger Counter = new AtomicInteger();
    private static MemoryMXBean MemBean = ManagementFactory.getMemoryMXBean();
    private static ThreadMXBean ThreadBean = ManagementFactory.getThreadMXBean();
    private final long startElapsed = System.nanoTime();
    private final long startCPU = ThreadBean.getCurrentThreadCpuTime();
    private long elapsedTime;
    private long cpuTime;
    private MemoryUsage heapMemoryUsage;
    private MemoryUsage nonHeapMemoryUsage;
    private final int id = Counter.incrementAndGet();

    public long getCpuTime() {
        return this.cpuTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public MemoryUsage getHeapMemoryUsage() {
        return this.heapMemoryUsage;
    }

    public int getId() {
        return this.id;
    }

    public MemoryUsage getNonHeapMemoryUsage() {
        return this.nonHeapMemoryUsage;
    }

    public void setHeapMemoryUsage(MemoryUsage heapMemoryUsage) {
        this.heapMemoryUsage = heapMemoryUsage;
    }

    public void setNonHeapMemoryUsage(MemoryUsage nonHeapMemoryUsage) {
        this.nonHeapMemoryUsage = nonHeapMemoryUsage;
    }

    public void stop() {
        this.elapsedTime = System.nanoTime() - this.startElapsed;
        this.cpuTime = ThreadBean.getCurrentThreadCpuTime() - this.startCPU;
        this.heapMemoryUsage = MemBean.getHeapMemoryUsage();
        this.nonHeapMemoryUsage = MemBean.getNonHeapMemoryUsage();
    }
}

