/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.servlet.common;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.file.TempTools;
import de.intarsys.tools.http.common.HttpTools;
import de.intarsys.tools.http.locator.FileItemLocator;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.servlet.common.WebContext;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.jakarta.JakartaServletFileUpload;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServletTools {
    private static final List<String> IP_HEADERS = Arrays.asList("x-forwarded-for", "proxy-client-ip", "wl-proxy-client-ip", "http_client_ip", "http_x-forwarded_for");
    private static final Logger Log = LoggerFactory.getLogger(ServletTools.class);
    public static final String ENV_ROOT_URL = "DE_INTARSYS_APPLICATION_ROOTURL";
    public static final String ENV_CONTEXT_PATH = "DE_INTARSYS_APPLICATION_CONTEXTPATH";
    private static final String HEADER_FORWARDED_PORT = "x-forwarded-port";
    private static final String HEADER_FORWARDED_PROTO = "x-forwarded-proto";
    private static final String HEADER_FORWARDED_HOST = "x-forwarded-host";
    public static final String HEADER_FORWARDED_PATH = "x-forwarded-path";
    public static final String PROP_ROOT_URL = "de.intarsys.application.rootUrl";
    public static final String PROP_CONTEXT_PATH = "de.intarsys.application.contextPath";
    private static final String PORT_SEPARATOR = ":";
    private static final String LIST_SEPARATOR = "[,;]";
    private static final String PROTO_HTTPS = "https";
    private static final String PROTO_HTTP = "http";
    private static final String PORT_443 = "443";
    private static final String PORT_80 = "80";
    private static final String PORT_UNDEFINED = "-1";
    public static final String TEMP_MULTIPARTITEMS = "de.intarsys.multipartitems";
    private static DiskFileItemFactory factory;
    private static FileCleaningTracker tracker;
    public static final String ATTRIBUTE_REQUEST_FILE = "de.intarsys.servlet.request.file";
    public static final String TEMP_UPLOADLOCATOR = "de.intarsys.uploadlocator";

    protected static ILocator basicCreateUploadLocator(HttpServletRequest request, String defaultName) throws IOException {
        FileLocator locator = null;
        List<FileItem> multipartItems = ServletTools.getMultipartItems((ServletRequest)request);
        if (multipartItems != null) {
            for (FileItem item : multipartItems) {
                if (item.isFormField()) continue;
                locator = new FileItemLocator(item);
                break;
            }
        } else {
            Object tempValue = request.getAttribute(ATTRIBUTE_REQUEST_FILE);
            if (tempValue instanceof File) {
                File tempFile = (File)tempValue;
                locator = new FileLocator(tempFile);
            } else {
                String name = ServletTools.getHeaderParameter(request, "Content-disposition", "filename", defaultName);
                File tempFile = FileTools.createTempFile((String)name);
                try (DeferredFileOutputStream os = new DeferredFileOutputStream(10000, tempFile);){
                    StreamTools.copy((InputStream)request.getInputStream(), (OutputStream)os);
                    if (os.isInMemory()) {
                        byte[] data = os.getData();
                        locator = new ByteArrayLocator(data, tempFile.getName());
                    } else {
                        locator = new FileLocator(tempFile);
                    }
                    tracker.track(tempFile, (Object)locator);
                }
            }
        }
        return locator;
    }

    public static List<FileItem> createMultipartItems(HttpServletRequest request) throws IOException {
        boolean isMultipart = ServletTools.isMultipart(request);
        if (isMultipart) {
            JakartaServletFileUpload upload = new JakartaServletFileUpload(ServletTools.getFileItemFactory(request.getServletContext()));
            try {
                return upload.parseRequest(request);
            }
            catch (FileUploadException e) {
                throw new IOException("upload error", e);
            }
        }
        return null;
    }

    public static ILocator createUploadLocator(HttpServletRequest request, String defaultName) throws IOException {
        ILocator result = (ILocator)request.getAttribute(TEMP_UPLOADLOCATOR);
        if (result == null) {
            result = ServletTools.basicCreateUploadLocator(request, defaultName);
            request.setAttribute(TEMP_UPLOADLOCATOR, (Object)result);
        }
        return result;
    }

    public static String getClientIp(HttpServletRequest request) {
        for (String ipHeader : IP_HEADERS) {
            String ip = request.getHeader(ipHeader);
            if (StringTools.isEmpty((String)ip) || ip.equalsIgnoreCase("unknown")) continue;
            return ip;
        }
        return request.getRemoteAddr();
    }

    private static synchronized FileItemFactory getFileItemFactory(ServletContext servletContext) {
        if (factory == null) {
            File tempDir = ServletTools.getTempDir(servletContext);
            factory = ((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setFileCleaningTracker(tracker).setPath(tempDir.toPath())).get();
        }
        return factory;
    }

    public static String getHeaderParameter(HttpServletRequest request, String headerName, String parameterName, String defaultValue) {
        String headerString = request.getHeader(headerName);
        return HttpTools.getHeaderElementParam((String)headerString, (String)parameterName, (String)defaultValue);
    }

    public static List<FileItem> getMultipartItems(ServletRequest request) throws IOException {
        List<FileItem> multipartItems = (List<FileItem>)request.getAttribute(TEMP_MULTIPARTITEMS);
        if (multipartItems == null && request instanceof HttpServletRequest) {
            multipartItems = ServletTools.createMultipartItems((HttpServletRequest)request);
            request.setAttribute(TEMP_MULTIPARTITEMS, multipartItems);
        }
        return multipartItems;
    }

    public static String getRequestContextPath() {
        HttpServletRequest request = WebContext.getRequest();
        return ServletTools.getRequestContextPath(request);
    }

    public static String getRequestContextPath(HttpServletRequest request) {
        ServletContext servletContext = request == null ? WebContext.getServletContext() : request.getServletContext();
        String contextPath = System.getProperty(PROP_CONTEXT_PATH);
        if (StringTools.isEmpty((String)contextPath)) {
            contextPath = System.getenv(ENV_CONTEXT_PATH);
            if (StringTools.isEmpty((String)contextPath)) {
                if (servletContext != null) {
                    contextPath = servletContext.getInitParameter(PROP_CONTEXT_PATH);
                    if (StringTools.isEmpty((String)contextPath)) {
                        contextPath = servletContext.getContextPath();
                    } else {
                        Log.debug("getRequestContextPath set in web.xml to '{}'", (Object)contextPath);
                    }
                }
            } else {
                Log.debug("getRequestContextPath set in environment to '{}'", (Object)contextPath);
            }
        } else {
            Log.debug("getRequestContextPath set in system property to '{}'", (Object)contextPath);
        }
        if (request == null) {
            return contextPath;
        }
        String xPath = request.getHeader(HEADER_FORWARDED_PATH);
        if (!StringTools.isEmpty((String)xPath)) {
            contextPath = xPath;
        }
        return contextPath;
    }

    public static Object getRequestParameter(ServletRequest request, String name) throws IOException {
        List<FileItem> multipartItems = ServletTools.getMultipartItems(request);
        if (multipartItems != null) {
            for (FileItem item : multipartItems) {
                if (item.getFieldName() == null || !item.getFieldName().equals(name)) continue;
                return item;
            }
        }
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            if (entry.getKey() == null || !((String)entry.getKey()).equals(name)) continue;
            return request.getParameter(name);
        }
        return null;
    }

    public static String[] getRequestParameterNames(ServletRequest request) {
        HashSet names = new HashSet(request.getParameterMap().keySet());
        try {
            List<FileItem> multipartItems = ServletTools.getMultipartItems(request);
            if (multipartItems != null) {
                for (FileItem item : multipartItems) {
                    names.add(item.getFieldName());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return names.toArray(new String[names.size()]);
    }

    public static String getRequestRoot(HttpServletRequest request) {
        String xPort;
        String xScheme;
        String[] tmpHosts;
        String[] tmpHostPort;
        ServletContext servletContext = request == null ? WebContext.getServletContext() : request.getServletContext();
        String rootUrl = System.getProperty(PROP_ROOT_URL);
        if (StringTools.isEmpty((String)rootUrl)) {
            rootUrl = System.getenv(ENV_ROOT_URL);
            if (StringTools.isEmpty((String)rootUrl)) {
                if (servletContext != null && !StringTools.isEmpty((String)(rootUrl = servletContext.getInitParameter(PROP_ROOT_URL)))) {
                    Log.debug("getRequestRoot set in web.xml to '{}'", (Object)rootUrl);
                }
            } else {
                Log.debug("getRequestRoot set in environment to '{}'", (Object)rootUrl);
            }
        } else {
            Log.debug("getRequestRoot set in system property to '{}'", (Object)rootUrl);
        }
        if (!StringTools.isEmpty((String)rootUrl)) {
            return rootUrl;
        }
        if (request == null) {
            throw new IllegalStateException("servlet request required");
        }
        String hostName = request.getHeader("Host");
        if (StringTools.isEmpty((String)hostName)) {
            hostName = request.getServerName();
        }
        Object hostPort = "" + request.getServerPort();
        String hostScheme = request.getScheme();
        String xHost = request.getHeader(HEADER_FORWARDED_HOST);
        if (!StringTools.isEmpty((String)xHost)) {
            hostName = xHost;
            hostPort = null;
            hostScheme = PROTO_HTTP;
        }
        if ((tmpHostPort = (hostName = (tmpHosts = hostName.split(LIST_SEPARATOR))[0]).split(PORT_SEPARATOR)).length == 2) {
            hostName = tmpHostPort[0];
            hostPort = tmpHostPort[1];
        }
        if (!StringTools.isEmpty((String)(xScheme = request.getHeader(HEADER_FORWARDED_PROTO)))) {
            String[] tmpScheme = xScheme.split(LIST_SEPARATOR);
            hostScheme = tmpScheme[0];
        }
        if (!StringTools.isEmpty((String)(xPort = request.getHeader(HEADER_FORWARDED_PORT)))) {
            String[] tmpPorts = xPort.split(LIST_SEPARATOR);
            hostPort = tmpPorts[0];
        }
        if (PROTO_HTTP.equals(hostScheme) && (PORT_UNDEFINED.equals(hostPort) || PORT_80.equals(hostPort))) {
            hostPort = null;
        }
        if (PROTO_HTTPS.equals(hostScheme) && (PORT_UNDEFINED.equals(hostPort) || PORT_443.equals(hostPort))) {
            hostPort = null;
        }
        return hostScheme + "://" + hostName + (String)(hostPort == null ? "" : PORT_SEPARATOR + (String)hostPort);
    }

    private static File getTempDir(ServletContext servletContext) {
        File tempDir = (File)servletContext.getAttribute("jakarta.servlet.context.tempdir");
        if (tempDir == null) {
            tempDir = TempTools.getTempDirVM();
        }
        return tempDir;
    }

    public static String getUser(HttpServletRequest request) {
        Principal principal = request.getUserPrincipal();
        if (principal == null) {
            return "<anonymous>";
        }
        return principal.getName();
    }

    public static boolean isMultipart(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    private ServletTools() {
    }

    static {
        tracker = new FileCleaningTracker();
    }
}

