/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.authenticate.common;

import de.intarsys.aaa.authenticate.impl.CommonAuthenticationState;
import de.intarsys.cloudsuite.gears.authenticate.common.CommonPrincipalFactory;
import de.intarsys.cloudsuite.gears.authenticate.common.IKeyConverter;
import de.intarsys.cloudsuite.gears.model.entity.principal.IPrincipal;
import de.intarsys.cloudsuite.gears.model.entity.principal.IPrincipalDao;
import jakarta.annotation.PostConstruct;
import java.security.Principal;

public class DaoBasedPrincipalFactory
extends CommonPrincipalFactory {
    private IKeyConverter keyConverter;
    private IPrincipalDao principalDao;

    public Principal createPrincipal(CommonAuthenticationState state) throws Exception {
        String id = this.getKeyConverter().createKey(state.getCredential());
        IPrincipal principal = (IPrincipal)this.getPrincipalDao().lookupItem((Object)id);
        return principal;
    }

    public IKeyConverter getKeyConverter() {
        return this.keyConverter;
    }

    public IPrincipalDao getPrincipalDao() {
        return this.principalDao;
    }

    @PostConstruct
    public void init() {
        if (this.getKeyConverter() == null) {
            throw new IllegalArgumentException("keyConverter can not be null");
        }
        if (this.getPrincipalDao() == null) {
            throw new IllegalArgumentException("principalDao can not be null");
        }
    }

    public void setKeyConverter(IKeyConverter keyConverter) {
        this.keyConverter = keyConverter;
    }

    public void setPrincipalDao(IPrincipalDao principalDao) {
        this.principalDao = principalDao;
    }
}

