/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.authenticate.common;

import de.intarsys.aaa.authenticate.api.AuthenticationFailed;
import de.intarsys.cloudsuite.gears.authenticate.common.UserPasswordCredential;
import de.intarsys.cloudsuite.gears.authenticate.common.UserPasswordCredentialVerifier;
import de.intarsys.cloudsuite.gears.model.entity.user.IUser;
import de.intarsys.cloudsuite.gears.model.entity.user.IUserDao;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.exception.InitializationException;
import de.intarsys.tools.string.CharacterTools;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class GenericUserPasswordCredentialVerifier
extends UserPasswordCredentialVerifier {
    private static final int BITS_PER_BYTE = 8;
    private static final int DEFAULT_KEY_SIZE_BYTES = 16;
    private static final int DEFAULT_ITERATIONS = 10000;
    private SecretKeyFactory factory;
    private IUserDao userDao;
    private int iterations = 10000;
    private int keySizeBytes = 16;

    @Override
    protected void basicVerify(UserPasswordCredential tempCredential) throws AuthenticationFailed {
        IUser user;
        try {
            user = (IUser)this.getUserDao().lookupItem((Object)tempCredential.getUsername());
        }
        catch (IOException e) {
            throw new AuthenticationFailed("authentication failed", (Throwable)e);
        }
        if (user == null) {
            throw new AuthenticationFailed("authentication failed");
        }
        char[] tempPassword = user.getPassword();
        if (CharacterTools.isEmpty((char[])tempPassword)) {
            String passwordHash;
            String tempSalt = user.getSalt();
            String tempPasswordHash = user.getPasswordHash();
            try {
                passwordHash = this.hash(tempSalt, tempCredential.getPassword());
            }
            catch (Exception e) {
                throw new AuthenticationFailed("authentication failed");
            }
            if (!passwordHash.equals(tempPasswordHash)) {
                throw new AuthenticationFailed("authentication failed");
            }
        } else if (!Arrays.equals(tempPassword, tempCredential.getPassword())) {
            throw new AuthenticationFailed("authentication failed");
        }
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getKeySizeBytes() {
        return this.keySizeBytes;
    }

    public IUserDao getUserDao() {
        return this.userDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String hash(String salt, char[] value) throws Exception {
        byte[] saltBytes = Base64.decode((String)salt);
        PBEKeySpec spec = new PBEKeySpec(value, saltBytes, this.getIterations(), this.getKeySizeBytes() * 8);
        try {
            SecretKey secretKey = this.factory.generateSecret(spec);
            String string = new String(Base64.encode((byte[])secretKey.getEncoded()));
            return string;
        }
        finally {
            spec.clearPassword();
        }
    }

    @PostConstruct
    public void init() {
        try {
            this.factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InitializationException((Throwable)e);
        }
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public void setKeySizeBytes(int keySizeBytes) {
        this.keySizeBytes = keySizeBytes;
    }

    public void setUserDao(IUserDao userProvider) {
        this.userDao = userProvider;
    }
}

