/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.authenticate.spring;

import de.intarsys.aaa.authenticate.impl.CommonAuthenticationState;
import de.intarsys.cloudsuite.gears.authenticate.common.CommonPrincipalFactory;
import de.intarsys.cloudsuite.gears.authenticate.spring.SpringSecurityCredential;
import de.intarsys.cloudsuite.gears.model.entity.principal.GenericPrincipal;
import jakarta.annotation.PostConstruct;
import java.security.Principal;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class JwtBasedPrincipalFactory
extends CommonPrincipalFactory {
    public Principal createPrincipal(CommonAuthenticationState state) throws Exception {
        Authentication authentication = ((SpringSecurityCredential)state.getCredential()).getAuthentication();
        if (!(authentication instanceof JwtAuthenticationToken)) {
            throw new IllegalArgumentException("JWT based authentication required");
        }
        Jwt jwt = (Jwt)((JwtAuthenticationToken)authentication).getToken();
        GenericPrincipal principal = new GenericPrincipal();
        principal.setName(jwt.getClaimAsString("sub"));
        for (Map.Entry entry : jwt.getClaims().entrySet()) {
            principal.setClaim((String)entry.getKey(), (Object)String.valueOf(entry.getValue()));
        }
        return principal;
    }

    @PostConstruct
    public void init() {
    }
}

