/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.authenticate.spring;

import de.intarsys.aaa.authenticate.api.AuthenticationFailed;
import de.intarsys.aaa.authenticate.api.ICredential;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationContext;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationModule;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationState;
import de.intarsys.cloudsuite.gears.authenticate.spring.SpringSecurityCredential;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.functor.IArgs;
import java.security.Principal;
import javax.security.auth.Subject;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class SpringSecurityAuthenticationContext
extends CommonAuthenticationContext {
    public SpringSecurityAuthenticationContext(CommonAuthenticationModule authenticationModule, Subject subject) {
        super(authenticationModule, subject);
    }

    protected IConversation<CommonAuthenticationState> basicAuthenticate(IArgs authenticationArgs) {
        try {
            IConversation conversation = this.createConversation(authenticationArgs);
            CommonAuthenticationState state = this.createState(conversation, authenticationArgs);
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication != null && authentication.isAuthenticated()) {
                state.setCredential((ICredential)new SpringSecurityCredential(authentication));
                conversation.complete((Object)state);
            } else {
                conversation.completeExceptionally((Throwable)new AuthenticationFailed("no valid authentication token"));
            }
            return conversation;
        }
        catch (Exception e) {
            return Conversation.failed((Throwable)e);
        }
    }

    protected void subjectInstall(CommonAuthenticationState state) throws Exception {
        Principal principal = this.createPrincipal(state);
        if (principal != null) {
            this.getSubject().getPrincipals().add(principal);
        }
    }
}

