/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.authenticate.spring;

import de.intarsys.aaa.authenticate.api.AuthenticationFailed;
import de.intarsys.aaa.authenticate.api.ICredential;
import de.intarsys.cloudsuite.gears.authenticate.spring.SpringSecurityCredential;
import de.intarsys.cloudsuite.gears.filter.authenticate.scheme.clienttls.IX509CertificateConverter;
import java.security.cert.X509Certificate;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class SpringSecurityCertificateConverter
implements IX509CertificateConverter {
    @Override
    public X509Certificate createX509Certificate(ICredential credential) throws AuthenticationFailed {
        if (!(credential instanceof SpringSecurityCredential)) {
            throw new AuthenticationFailed("authentication failed");
        }
        SpringSecurityCredential tempCredential = (SpringSecurityCredential)credential;
        Authentication authentication = tempCredential.getAuthentication();
        if (!(authentication instanceof PreAuthenticatedAuthenticationToken)) {
            throw new AuthenticationFailed("authentication failed");
        }
        Object springCredentials = authentication.getCredentials();
        if (!(springCredentials instanceof X509Certificate)) {
            throw new AuthenticationFailed("authentication failed");
        }
        return (X509Certificate)springCredentials;
    }
}

