/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.filter.authenticate.common;

import de.intarsys.aaa.authenticate.api.AuthenticationException;
import de.intarsys.tools.exception.ExceptionTools;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthenticationFilter
implements ContainerRequestFilter {
    private static final Logger Log = LoggerFactory.getLogger(AuthenticationFilter.class);
    public static final int PRIORITY = 1000;

    protected abstract void authenticate(ContainerRequestContext var1) throws AuthenticationException;

    public void filter(ContainerRequestContext requestContext) {
        try {
            this.authenticate(requestContext);
        }
        catch (AuthenticationException e) {
            Log.warn("{} authentication failure ({})", (Object)this, (Object)e.getMessage());
            throw new NotAuthorizedException(e.getMessage(), (Throwable)e, (Object)this.getAuthenticationScheme(), new Object[0]);
        }
        catch (Exception e) {
            Log.warn("{} unexpected authentication failure", (Object)this, (Object)e);
            throw new NotAuthorizedException(ExceptionTools.getMessage((Throwable)e), (Throwable)e, (Object)this.getAuthenticationScheme(), new Object[0]);
        }
    }

    protected abstract String getAuthenticationScheme();
}

