/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.filter.authenticate.common;

import de.intarsys.aaa.authenticate.api.AuthenticationCanceled;
import de.intarsys.aaa.authenticate.api.AuthenticationException;
import de.intarsys.aaa.authenticate.api.AuthenticationFailed;
import de.intarsys.aaa.authenticate.api.IAuthenticationContext;
import de.intarsys.aaa.authenticate.api.IAuthenticationModule;
import de.intarsys.aaa.authenticate.api.ICredential;
import de.intarsys.aaa.authenticate.api.RequestCredential;
import de.intarsys.cloudsuite.gears.filter.authenticate.common.AuthenticationFilter;
import de.intarsys.cloudsuite.gears.filter.authenticate.common.CredentialExtractor;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.CancelStage;
import de.intarsys.tools.conversation.impl.ErrorStage;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;

@Priority(value=1000)
public class GenericAuthenticationFilter
extends AuthenticationFilter {
    private static final Logger Log = LoggerFactory.getLogger(GenericAuthenticationFilter.class);
    @Autowired
    private IAuthenticationModule authenticationModule;
    private CredentialExtractor credentialExtractor;
    @Autowired
    private IAuthenticationContext authenticationContext;

    @Override
    protected void authenticate(ContainerRequestContext requestContext) throws AuthenticationException {
        ICredential credential = this.getCredentialExtractor().getCredential(requestContext);
        if (credential == null) {
            throw new AuthenticationFailed("authentication failed");
        }
        IConversation conversation = this.getAuthenticationContext().authenticate((IArgs)Args.create());
        IReplyStage stage = conversation.getReplyStage();
        while (!stage.isFinal()) {
            if (!(stage instanceof RequestCredential)) {
                Log.warn("{} unexpected authentication stage {}", (Object)this, (Object)stage);
                throw new AuthenticationFailed("authentication failed");
            }
            ((RequestCredential)stage).acknowledge((Object)credential);
            stage = conversation.getReplyStage();
        }
        if (stage instanceof ErrorStage) {
            throw (AuthenticationException)ExceptionTools.createTypedFromChain((Throwable)((ErrorStage)stage).getThrowable(), AuthenticationException.class);
        }
        if (stage instanceof CancelStage) {
            throw new AuthenticationCanceled();
        }
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.TARGET_CLASS, scopeName="session")
    public IAuthenticationContext createAuthenticationContext() {
        return this.getAuthenticationModule().createContext(null);
    }

    public IAuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    public IAuthenticationModule getAuthenticationModule() {
        return this.authenticationModule;
    }

    @Override
    protected String getAuthenticationScheme() {
        return this.getCredentialExtractor().getAuthenticationScheme();
    }

    public CredentialExtractor getCredentialExtractor() {
        return this.credentialExtractor;
    }

    @PostConstruct
    public void init() {
        Log.warn("GenericAuthenticationFilter is deprectaed and will be removed in upcoming versions. Migrate to spring based security!");
    }

    public void setAuthenticationModule(IAuthenticationModule authenticationModule) {
        this.authenticationModule = authenticationModule;
    }

    public void setCredentialExtractor(CredentialExtractor credentialExtractor) {
        this.credentialExtractor = credentialExtractor;
    }
}

