/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.filter.authenticate.scheme.basic;

import de.intarsys.aaa.authenticate.api.AuthenticationFailed;
import de.intarsys.aaa.authenticate.api.ICredential;
import de.intarsys.cloudsuite.gears.authenticate.common.UserPasswordCredential;
import de.intarsys.cloudsuite.gears.filter.authenticate.common.CredentialExtractor;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.string.StringTools;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.io.IOException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCredentialExtractor
extends CredentialExtractor {
    private static final Logger Log = LoggerFactory.getLogger(BasicCredentialExtractor.class);

    @Override
    public String getAuthenticationScheme() {
        return "Basic";
    }

    @Override
    public ICredential getCredential(ContainerRequestContext requestContext) throws AuthenticationFailed {
        String authorization = requestContext.getHeaderString("Authorization");
        return this.getCredential(authorization);
    }

    protected UserPasswordCredential getCredential(String authorization) throws AuthenticationFailed {
        String decoded;
        if (StringTools.isEmpty((String)authorization)) {
            return null;
        }
        if (!authorization.toLowerCase(Locale.ROOT).startsWith("Basic".toLowerCase(Locale.ROOT) + " ")) {
            Log.debug("{} auth scheme mismatch({})", (Object)this, (Object)authorization);
            throw new AuthenticationFailed("authentication failed");
        }
        String encoded = authorization.substring("Basic".length()).trim();
        if (StringTools.isEmpty((String)encoded)) {
            Log.debug("{} no credentials", (Object)this);
            return null;
        }
        try {
            decoded = new String(Base64.decode((String)encoded));
        }
        catch (IOException e) {
            Log.debug("{} malformed credentials, not Base64", (Object)this);
            throw new AuthenticationFailed("authentication failed");
        }
        String[] split = decoded.split(":", 2);
        if (split.length != 2) {
            Log.debug("{} malformed credentials, no password", (Object)this);
            throw new AuthenticationFailed("authentication failed");
        }
        return new UserPasswordCredential(split[0], split[1].toCharArray());
    }
}

