/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.filter.authenticate.scheme.bearer;

import de.intarsys.aaa.authenticate.api.AuthenticationFailed;
import de.intarsys.aaa.authenticate.api.ICredential;
import de.intarsys.cloudsuite.gears.filter.authenticate.common.CredentialExtractor;
import de.intarsys.cloudsuite.gears.filter.authenticate.scheme.bearer.BearerTokenCredential;
import de.intarsys.tools.string.StringTools;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BearerTokenCredentialExtractor
extends CredentialExtractor {
    private static final Logger Log = LoggerFactory.getLogger(BearerTokenCredentialExtractor.class);

    @Override
    public String getAuthenticationScheme() {
        return "Bearer";
    }

    @Override
    public ICredential getCredential(ContainerRequestContext requestContext) throws AuthenticationFailed {
        String authorization = requestContext.getHeaderString("Authorization");
        return this.getCredential(authorization);
    }

    protected BearerTokenCredential getCredential(String authorization) throws AuthenticationFailed {
        if (StringTools.isEmpty((String)authorization)) {
            return null;
        }
        if (!authorization.toLowerCase(Locale.ROOT).startsWith("Bearer".toLowerCase(Locale.ROOT) + " ")) {
            Log.debug("{} auth scheme mismatch({})", (Object)this, (Object)authorization);
            throw new AuthenticationFailed("authentication failed");
        }
        String token = authorization.substring("Bearer".length()).trim();
        if (StringTools.isEmpty((String)token)) {
            Log.debug("{} no credentials", (Object)this);
            return null;
        }
        return new BearerTokenCredential(token);
    }
}

