/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.filter.authenticate.scheme.clienttls;

import de.intarsys.aaa.authenticate.api.AuthenticationFailed;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationState;
import de.intarsys.cloudsuite.gears.filter.authenticate.scheme.clienttls.CommonX509CertificateCredentialVerifier;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import jakarta.annotation.PostConstruct;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;

public class PkixX509CertificateCredentialVerifier
extends CommonX509CertificateCredentialVerifier {
    private IByteProvider trustStoreKeyProvider;
    private String trustStoreFileName;
    private KeyStore trustStore;

    @Override
    protected void basicVerify(CommonAuthenticationState state, X509Certificate certificate) throws AuthenticationFailed {
        try {
            PKIXParameters params = new PKIXParameters(this.getTrustStore());
            params.setRevocationEnabled(true);
            CertPath certPath = CertificateFactory.getInstance("X.509").generateCertPath(ListTools.with((Object[])new X509Certificate[]{certificate}));
            CertPathValidator cpv = CertPathValidator.getInstance("PKIX");
            cpv.validate(certPath, params);
        }
        catch (GeneralSecurityException e) {
            throw new AuthenticationFailed("invalid credentials", (Throwable)e);
        }
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public String getTrustStoreFileName() {
        return this.trustStoreFileName;
    }

    public IByteProvider getTrustStoreKeyProvider() {
        return this.trustStoreKeyProvider;
    }

    @PostConstruct
    public void init() {
        try {
            FileLocator locator = new FileLocator(this.getTrustStoreFileName());
            char[] password = new String(this.getTrustStoreKeyProvider().getBytes(), StandardCharsets.UTF_8).toCharArray();
            this.trustStore = this.load((ILocator)locator, password);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot load keystore", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyStore load(ILocator locator, char[] password) throws IOException, GeneralSecurityException {
        InputStream is = null;
        try {
            is = locator.getInputStream();
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(is, password);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        finally {
            StreamTools.close((Closeable)is);
        }
    }

    public void setTrustStore(KeyStore keyStore) {
        this.trustStore = keyStore;
    }

    public void setTrustStoreFileName(String value) {
        this.trustStoreFileName = value;
    }

    public void setTrustStoreKeyProvider(IByteProvider value) {
        this.trustStoreKeyProvider = value;
    }
}

