/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.filter.authenticate.scheme.clienttls;

import de.intarsys.aaa.authenticate.api.AuthenticationFailed;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationState;
import de.intarsys.cloudsuite.gears.filter.authenticate.scheme.clienttls.CommonX509CertificateCredentialVerifier;
import de.intarsys.cloudsuite.gears.model.entity.certificate.IX509CertificateDao;
import de.intarsys.cloudsuite.gears.model.entity.certificate.X509CertificateLookupKey;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class StaticX509CertificateCredentialVerifier
extends CommonX509CertificateCredentialVerifier {
    private IX509CertificateDao certificateDao;

    @Override
    protected void basicVerify(CommonAuthenticationState state, X509Certificate certificate) throws AuthenticationFailed {
        BigInteger serial = certificate.getSerialNumber();
        X500Principal issuer = certificate.getIssuerX500Principal();
        try {
            X509CertificateLookupKey key = new X509CertificateLookupKey(issuer, serial);
            X509Certificate persistentCert = (X509Certificate)this.getCertificateDao().lookupItem((Object)key);
            if (persistentCert == null) {
                throw new AuthenticationFailed("invalid credentials");
            }
        }
        catch (IOException e) {
            throw new AuthenticationFailed("invalid credentials", (Throwable)e);
        }
    }

    public IX509CertificateDao getCertificateDao() {
        return this.certificateDao;
    }

    public void setCertificateDao(IX509CertificateDao certificateProvider) {
        this.certificateDao = certificateProvider;
    }
}

