/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.filter.authenticate.scheme.clienttls;

import de.intarsys.aaa.authenticate.api.AuthenticationFailed;
import de.intarsys.aaa.authenticate.api.ICredential;
import de.intarsys.cloudsuite.gears.filter.authenticate.common.CredentialExtractor;
import de.intarsys.cloudsuite.gears.filter.authenticate.scheme.clienttls.X509CertificateCredential;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertificateCredentialExtractor
extends CredentialExtractor {
    private static final Logger Log = LoggerFactory.getLogger(X509CertificateCredentialExtractor.class);
    public static final String REQUEST_ATTR_X509_CERTIFICATE = "jakarta.servlet.request.X509Certificate";
    private String sslClientCertificateHeaderName = "ssl-client-cert";
    private boolean sslClientCertificateHeaderUrlDecode = false;
    private boolean sslClientCertificateHeaderApacheDecode = false;

    @Override
    public String getAuthenticationScheme() {
        return "Bearer";
    }

    protected X509Certificate getCertificateFromHeader(ContainerRequestContext requestContext, String headerName) throws IOException, GeneralSecurityException {
        String headerValue = (String)requestContext.getHeaders().getFirst((Object)headerName);
        if (headerValue == null || headerValue.isEmpty()) {
            return null;
        }
        String certString = headerValue;
        byte[] encodedCertificate = null;
        if (this.isSslClientCertificateHeaderApacheDecode()) {
            encodedCertificate = Base64.getDecoder().decode(certString.replaceAll("-----BEGIN CERTIFICATE-----", "").replaceAll("-----END CERTIFICATE-----", "").replaceAll(" ", ""));
        } else {
            if (this.isSslClientCertificateHeaderUrlDecode()) {
                certString = URLDecoder.decode(certString, "ASCII");
            }
            encodedCertificate = certString.getBytes(StandardCharsets.US_ASCII);
        }
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509", "BC");
        try (ByteArrayInputStream is = new ByteArrayInputStream(encodedCertificate);){
            Certificate certificate = certificateFactory.generateCertificate(is);
            if (certificate instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)certificate;
                return x509Certificate;
            }
        }
        return null;
    }

    @Override
    public ICredential getCredential(ContainerRequestContext requestContext) throws AuthenticationFailed {
        X509Certificate certificate = null;
        X509Certificate[] certChain = (X509Certificate[])requestContext.getProperty(REQUEST_ATTR_X509_CERTIFICATE);
        if (certChain == null) {
            try {
                certificate = this.getCertificateFromHeader(requestContext, this.getSslClientCertificateHeaderName());
            }
            catch (IOException | GeneralSecurityException e) {
                Log.warn("{} Error processing header {}: {}", new Object[]{this, this.getSslClientCertificateHeaderName(), e.getMessage(), e});
            }
        } else {
            certificate = certChain[0];
        }
        if (certificate == null) {
            Log.warn("{} no client certificate found, deny access", (Object)this);
            throw new AuthenticationFailed("authentication failed");
        }
        return new X509CertificateCredential(certificate);
    }

    public String getSslClientCertificateHeaderName() {
        return this.sslClientCertificateHeaderName;
    }

    public boolean isSslClientCertificateHeaderApacheDecode() {
        return this.sslClientCertificateHeaderApacheDecode;
    }

    public boolean isSslClientCertificateHeaderUrlDecode() {
        return this.sslClientCertificateHeaderUrlDecode;
    }

    public void setSslClientCertificateHeaderApacheDecode(boolean sslClientCertificateHeaderApacheDecode) {
        this.sslClientCertificateHeaderApacheDecode = sslClientCertificateHeaderApacheDecode;
    }

    public void setSslClientCertificateHeaderName(String sslClientCertificateHeaderName) {
        this.sslClientCertificateHeaderName = sslClientCertificateHeaderName;
    }

    public void setSslClientCertificateHeaderUrlDecode(boolean sslClientCertificateHeaderUrlDecode) {
        this.sslClientCertificateHeaderUrlDecode = sslClientCertificateHeaderUrlDecode;
    }
}

