/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.filter.authenticate.scheme.clienttls;

import de.intarsys.aaa.authenticate.impl.CommonAuthenticationState;
import de.intarsys.cloudsuite.gears.authenticate.common.CommonPrincipalFactory;
import de.intarsys.cloudsuite.gears.filter.authenticate.scheme.clienttls.IX509CertificateConverter;
import de.intarsys.cloudsuite.gears.filter.authenticate.scheme.clienttls.X509CertificateCredentialCertificateConverter;
import de.intarsys.cloudsuite.gears.model.entity.principal.GenericPrincipal;
import java.security.Principal;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Base64;

public class X509CertificatePrincipalFactory
extends CommonPrincipalFactory {
    private IX509CertificateConverter certificateConverter = new X509CertificateCredentialCertificateConverter();

    public Principal createPrincipal(CommonAuthenticationState state) throws Exception {
        X509Certificate certificate = this.getCertificateConverter().createX509Certificate(state.getCredential());
        String dn = certificate.getSubjectDN().getName();
        GenericPrincipal principal = new GenericPrincipal();
        principal.setName(dn);
        principal.setClaim("certificate", (Object)this.pemEncode(certificate));
        return principal;
    }

    public IX509CertificateConverter getCertificateConverter() {
        return this.certificateConverter;
    }

    protected String pemEncode(X509Certificate certificate) throws CertificateEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN CERTIFICATE-----\r\n");
        sb.append(Base64.getEncoder().encodeToString(certificate.getEncoded())).append("\r\n");
        sb.append("-----END CERTIFICATE-----\r\n");
        return sb.toString();
    }

    public void setCertificateConverter(IX509CertificateConverter certificateConverter) {
        this.certificateConverter = certificateConverter;
    }
}

