/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.filter.authenticate.spring;

import de.intarsys.aaa.authenticate.api.IAuthenticationContext;
import de.intarsys.aaa.authenticate.api.IAuthenticationModule;
import de.intarsys.aaa.authenticate.impl.IPrincipalFactory;
import de.intarsys.cloudsuite.gears.authenticate.common.AuthenticationContextProvider;
import de.intarsys.cloudsuite.gears.authenticate.spring.SpringSecurityAuthenticationModule;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import jakarta.annotation.PostConstruct;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class SpringSecurityAuthenticationFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    protected static final String PROP_ENTERED = "de.intarsys.cloudsuite.gears.filter.authenticate.spring.entered";
    @Autowired
    @Qualifier(value="authPrincipalFactory")
    private IPrincipalFactory principalFactory;
    private SpringSecurityAuthenticationModule authenticationModule;

    public void filter(ContainerRequestContext requestContext) {
        Args args = Args.create();
        IAuthenticationContext authenticationContext = AuthenticationContextProvider.getAuthenticationContext();
        if (authenticationContext == null) {
            authenticationContext = this.getAuthenticationModule().createContext(null);
        }
        AuthenticationContextProvider.enter(authenticationContext);
        requestContext.setProperty(PROP_ENTERED, (Object)true);
        authenticationContext.authenticate((IArgs)args);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (Boolean.TRUE.equals(requestContext.getProperty(PROP_ENTERED))) {
            requestContext.removeProperty(PROP_ENTERED);
            AuthenticationContextProvider.leave();
        }
    }

    public IAuthenticationModule getAuthenticationModule() {
        return this.authenticationModule;
    }

    public IPrincipalFactory getPrincipalFactory() {
        return this.principalFactory;
    }

    @PostConstruct
    public void init() {
        this.authenticationModule = new SpringSecurityAuthenticationModule();
        this.authenticationModule.setPrincipalFactory(this.getPrincipalFactory());
    }

    public void setPrincipalFactory(IPrincipalFactory principalFactory) {
        this.principalFactory = principalFactory;
    }
}

