/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.cms.EncryptedKey;
import de.intarsys.asn1.cms.KeyEncryptionAlgorithmIdentifier;
import de.intarsys.asn1.cms.RecipientIdentifier;
import de.intarsys.asn1.common.Version;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;

public class KeyTransRecipientInfo
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public EncryptedKey getEncryptedKey() {
        return (EncryptedKey)EncryptedKey.FACTORY.create(this.getValueHolder().getChild(3));
    }

    public KeyEncryptionAlgorithmIdentifier getKeyEncryptionAlgorithmIdentifier() {
        return (KeyEncryptionAlgorithmIdentifier)KeyEncryptionAlgorithmIdentifier.FACTORY.create(this.getValueHolder().getChild(2));
    }

    public RecipientIdentifier getRecipientIdentifier() {
        ASN1ValueHolder obj = this.getValueHolder().getChild(1);
        return (RecipientIdentifier)RecipientIdentifier.FACTORY.create(obj);
    }

    public Version getVersion() {
        return (Version)Version.FACTORY.create(this.getValueHolder().getChild(0));
    }

    public void setEncryptedKey(EncryptedKey encryptedKey) {
        this.getValueHolder().setChild(3, encryptedKey);
    }

    public void setKeyEncryptionAlgorithmIdentifier(KeyEncryptionAlgorithmIdentifier keyEncAlgId) {
        this.getValueHolder().setChild(2, keyEncAlgId);
    }

    public void setRecipientIdentifier(RecipientIdentifier recipientIdentifier) {
        this.getValueHolder().setChild(1, recipientIdentifier);
        if (recipientIdentifier.isIssuerAndSerialNumber()) {
            this.setVersion(Version.create(0));
        } else {
            this.setVersion(Version.create(2));
        }
    }

    public void setVersion(Version version) {
        this.getValueHolder().setChild(0, version);
    }

    public static class Factory
    extends ASN1Based.Factory<KeyTransRecipientInfo> {
    }
}

