/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.cms.CMSContent;
import de.intarsys.asn1.cms.CertificateSet;
import de.intarsys.asn1.cms.ContentInfo;
import de.intarsys.asn1.cms.DigestAlgorithmIdentifiers;
import de.intarsys.asn1.cms.EncapsulatedContentInfo;
import de.intarsys.asn1.cms.RevocationInfoChoices;
import de.intarsys.asn1.cms.SignerInfos;
import de.intarsys.asn1.common.Version;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.string.PrettyPrinter;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;

public class SignedData
extends CMSContent {
    public static final Factory FACTORY = new Factory();

    public SignedData copy() throws IOException {
        return (SignedData)FACTORY.create((ASN1Encodable)this.basicCopy());
    }

    public CertificateSet getCertificates() {
        ASN1ValueHolder object = this.getValueHolder().getNextTaggedGetChild(3, 0, false);
        return (CertificateSet)CertificateSet.FACTORY.create(object);
    }

    public RevocationInfoChoices getCrls() {
        return (RevocationInfoChoices)RevocationInfoChoices.FACTORY.create(this.getValueHolder().getNextTaggedGetChild(3, 1, false));
    }

    public DigestAlgorithmIdentifiers getDigestAlgorithms() {
        return (DigestAlgorithmIdentifiers)DigestAlgorithmIdentifiers.FACTORY.create(this.getValueHolder().getChild(1));
    }

    public EncapsulatedContentInfo getEncapContentInfo() {
        return (EncapsulatedContentInfo)EncapsulatedContentInfo.FACTORY.create(this.getValueHolder().getChild(2));
    }

    public SignerInfos getSignerInfos() {
        return (SignerInfos)SignerInfos.FACTORY.create(this.getValueHolder().getNextNotTagged(3));
    }

    private boolean isCertificatesExistent() {
        ASN1TaggedHolder o = this.getValueHolder().getNextTagged(3, 0);
        return o != null;
    }

    private boolean isCrlsExistent() {
        ASN1TaggedHolder o = this.getValueHolder().getNextTagged(3, 1);
        return o != null;
    }

    public void setCertificates(CertificateSet certificates) {
        ASN1TaggedHolder tagged = new ASN1TaggedHolder(false, 0, certificates);
        if (this.isCertificatesExistent()) {
            this.getValueHolder().setChild(3, tagged);
        } else {
            this.getValueHolder().insertChild(3, tagged);
        }
    }

    public void setCrls(RevocationInfoChoices crls) {
        ASN1TaggedHolder tagged = new ASN1TaggedHolder(false, 1, crls);
        int index = 3;
        if (this.isCertificatesExistent()) {
            ++index;
        }
        if (this.isCrlsExistent()) {
            this.getValueHolder().setChild(index, tagged);
        } else {
            this.getValueHolder().insertChild(index, tagged);
        }
    }

    public void setDigestAlgorithms(DigestAlgorithmIdentifiers destDigAlgoIds) {
        this.getValueHolder().setChild(1, destDigAlgoIds);
    }

    public void setEncapContentInfo(ContentInfo encap) {
        this.getValueHolder().setChild(2, encap);
    }

    public void setSignerInfos(SignerInfos signerInfos) {
        int index = 3;
        if (this.isCertificatesExistent()) {
            ++index;
        }
        if (this.isCrlsExistent()) {
            ++index;
        }
        this.getValueHolder().setChild(index, signerInfos);
    }

    public void setVersionAccordingToContent() {
        int version = 1;
        if (this.getCertificates() != null && this.getCertificates().isTypeOtherPresent()) {
            version = 5;
        } else if (this.getCrls() != null && this.getCrls().isTypeOtherPresent()) {
            version = 5;
        } else if (this.getCertificates() != null && this.getCertificates().isTypeAttributeCertificateV2Present()) {
            version = 4;
        } else if (this.getCertificates() != null && this.getCertificates().isTypeAttributeCertificateV1Present()) {
            version = 3;
        } else if (this.getSignerInfos() != null && this.getSignerInfos().isAnySignerInfoVersion(3)) {
            version = 3;
        } else if (this.getEncapContentInfo() != null && !this.getEncapContentInfo().isContentTypeData()) {
            version = 3;
        }
        this.setVersion(Version.create(version));
    }

    @Override
    public void toString(PrettyPrinter printer) {
        printer.appendMember("version", (Object)this.getValueHolder().getChild(0), null);
        printer.appendMember("digestAlgorithms", (Object)this.getDigestAlgorithms(), null);
        printer.appendMember("encapContentInfo", (Object)this.getEncapContentInfo(), null);
    }

    public static class Factory
    extends CMSContent.Factory<SignedData> {
        @Override
        public boolean isFactoryFor(String oid) {
            if (oid.equals("1.2.840.113549.1.7.2")) {
                return true;
            }
            return super.isFactoryFor(oid);
        }
    }
}

