/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms.attr;

import de.intarsys.asn1.cms.attr.ESSCertID;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1SequenceHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SigningCertificate
extends ASN1Based {
    public static final Factory<SigningCertificate> FACTORY = new Factory();

    public void addCert(ESSCertID certId) {
        ASN1ValueHolder certs = this.getValueHolder().getChild(0);
        if (certs == null) {
            certs = new ASN1SequenceHolder();
            this.getValueHolder().setChild(0, certs);
        }
        this.getValueHolder().setChanged(true);
        certs.addChild(certId);
    }

    public ESSCertID getCert(int index) {
        ASN1ValueHolder certs = this.getValueHolder().getChild(0);
        if (certs == null) {
            return null;
        }
        ASN1ValueHolder o = certs.getChild(index);
        return (ESSCertID)this.getFactory().create(o);
    }

    public int getCertCount() {
        ASN1ValueHolder certs = this.getValueHolder().getChild(0);
        return certs == null ? 0 : certs.size();
    }

    public List<ESSCertID> getCerts() {
        int count = this.getCertCount();
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList<ESSCertID> result = new ArrayList<ESSCertID>(count);
        for (int i = 0; i < count; ++i) {
            result.add(this.getCert(i));
        }
        return result;
    }

    protected ASN1Based.Factory getFactory() {
        return ESSCertID.FACTORY;
    }

    public static class Factory<T extends SigningCertificate>
    extends ASN1Based.Factory<T> {
    }
}

