/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.model;

import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.collection.SingleObjectIterator;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERTaggedObject;

public class ASN1ApplicationSpecificHolder
extends ASN1ValueHolder {
    private ASN1ValueHolder nested;
    private final int tagNo;
    private Boolean explicit;
    private final boolean constructed;

    protected ASN1ApplicationSpecificHolder(ASN1TaggedObject value) {
        super((ASN1Primitive)value);
        this.tagNo = value.getTagNo();
        this.constructed = value.isExplicit() || value.getBaseObject() instanceof ASN1Sequence || value.getBaseObject() instanceof ASN1Set;
    }

    public ASN1ApplicationSpecificHolder(boolean explicit, int tagNo, ASN1Encodable value) {
        this.setChanged(true);
        this.explicit = explicit;
        this.tagNo = tagNo;
        this.constructed = explicit;
        this.setChild(value);
    }

    @Override
    public void addChild(ASN1Encodable object) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ASN1Primitive createASN1Primitive() {
        return new DERTaggedObject(this.isExplicit(), 64, this.tagNo, (ASN1Encodable)this.getChild().toASN1Primitive());
    }

    protected ASN1ValueHolder createNested() {
        ASN1Object baseObject = this.getValue().getBaseObject();
        ASN1ValueHolder nestedHolder = ASN1ValueHolder.create((ASN1Encodable)baseObject);
        nestedHolder.setChanged(false);
        return nestedHolder;
    }

    @Override
    public ASN1ValueHolder getChild() {
        if (this.nested == null) {
            this.nested = this.createNested();
            if (this.nested != null) {
                this.nested.setContainer(this);
            }
        }
        return this.nested;
    }

    @Override
    public ASN1ValueHolder getChild(int index) {
        throw new UnsupportedOperationException();
    }

    public int getTagNo() {
        return this.tagNo;
    }

    public ASN1TaggedObject getValue() {
        return (ASN1TaggedObject)super.getValue();
    }

    @Override
    public void insertChild(int index, ASN1Encodable asn1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isApplicationSpecific() {
        return true;
    }

    @Override
    public boolean isChanged() {
        if (this.nested == null) {
            return super.isChanged();
        }
        return super.isChanged() || this.nested.isChanged();
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    @Override
    public boolean isExplicit() {
        if (this.explicit == null) {
            return this.getValue().isExplicit();
        }
        return this.explicit;
    }

    @Override
    public Iterator<ASN1ValueHolder> iterator() {
        return new SingleObjectIterator((Object)this.getChild());
    }

    @Override
    public void setChild(ASN1Encodable newValue) {
        this.setChanged(true);
        this.nested = ASN1ValueHolder.create(newValue);
        if (this.nested != null) {
            this.nested.setContainer(this);
        }
    }

    @Override
    public void setChild(int index, ASN1Encodable asn1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setExplicit(boolean value) {
        this.explicit = value;
    }

    @Override
    public int size() {
        return 1;
    }
}

