/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.policy;

import de.intarsys.asn1.model.ASN1Based;
import java.text.ParseException;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigningPeriod
extends ASN1Based {
    public static final Factory FACTORY = new Factory();
    private static final Logger Log = LoggerFactory.getLogger(SigningPeriod.class);

    public Date getNotAfter() {
        if (this.size() < 2) {
            return null;
        }
        ASN1GeneralizedTime value = ASN1GeneralizedTime.getInstance((Object)this.getValueHolder().getChild(1).toASN1Primitive());
        try {
            return value.getDate();
        }
        catch (ParseException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Date getNotBefore() {
        ASN1GeneralizedTime value = ASN1GeneralizedTime.getInstance((Object)this.getValueHolder().getChild(0).toASN1Primitive());
        try {
            return value.getDate();
        }
        catch (ParseException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setNotAfter(Date time) {
        this.getValueHolder().setChild(1, (ASN1Encodable)new ASN1GeneralizedTime(time));
    }

    public void setNotBefore(Date time) {
        this.getValueHolder().setChild(0, (ASN1Encodable)new ASN1GeneralizedTime(time));
    }

    public static class Factory
    extends ASN1Based.Factory<SigningPeriod> {
    }
}

