/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.x509;

import de.intarsys.asn1.cms.IssuerAndSerialNumber;
import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.common.SubjectKeyIdentifier;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.x509.CertificateSerialNumber;
import de.intarsys.asn1.x509.CommonCertificate;
import de.intarsys.asn1.x509.Extension;
import de.intarsys.asn1.x509.Name;
import de.intarsys.asn1.x509.TBSCertificate;
import java.io.IOException;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x509.X509Extensions;

public class Certificate
extends CommonCertificate {
    public static final Factory FACTORY = new Factory();

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return IssuerAndSerialNumber.create(this.getIssuerName(), this.getSerialNumber());
    }

    public Name getIssuerName() {
        TBSCertificate tbs = this.getTBSCertificate();
        return tbs.getIssuer();
    }

    public CertificateSerialNumber getSerialNumber() {
        TBSCertificate tbs = this.getTBSCertificate();
        return tbs.getSerialNumber();
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return (AlgorithmIdentifier)AlgorithmIdentifier.FACTORY.create(this.getValueHolder().getChild(1));
    }

    public byte[] getSignatureValue() {
        return this.getValueHolder().getChild(2).toDERBitString().getBytes();
    }

    public TBSCertificate getTBSCertificate() {
        return (TBSCertificate)TBSCertificate.FACTORY.create(this.getValueHolder().getChild(0));
    }

    @Override
    public boolean isKeyCertificate() {
        return true;
    }

    public boolean matches(CertificateSerialNumber serialNumber) {
        TBSCertificate tbs = this.getTBSCertificate();
        return tbs.getSerialNumber().equals(serialNumber);
    }

    public boolean matches(IssuerAndSerialNumber issuerAndSerialNumber) {
        return this.matchesIssuer(issuerAndSerialNumber.getIssuer()) && this.matches(issuerAndSerialNumber.getSerialNumber());
    }

    public boolean matches(SubjectKeyIdentifier subjectKeyIdentifier) {
        ASN1OctetString keyIdentifier;
        TBSCertificate tbs = this.getTBSCertificate();
        String id = X509Extensions.SubjectKeyIdentifier.getId();
        Extension subjectKeyExt = tbs.getExtensions().getExtensionById(id);
        if (subjectKeyExt == null) {
            return false;
        }
        byte[] octetStringValue = subjectKeyExt.getValue();
        try {
            keyIdentifier = (ASN1OctetString)ASN1Tools.create(octetStringValue);
        }
        catch (IOException e) {
            return false;
        }
        return Arrays.equals(subjectKeyIdentifier.getBytes(), keyIdentifier.getOctets());
    }

    public boolean matchesIssuer(Name issuer) {
        TBSCertificate tbs = this.getTBSCertificate();
        return tbs.getIssuer().equals(issuer);
    }

    public void setSignatureAlgorithm(AlgorithmIdentifier signatureAlgo) {
        this.getValueHolder().setChild(1, signatureAlgo);
    }

    public void setSignatureValue(byte[] signatureValue) {
        this.getValueHolder().setChild(2, (ASN1Encodable)new DERBitString(signatureValue));
    }

    public void setTBSCertificate(TBSCertificate tbsCert) {
        this.getValueHolder().setChild(0, tbsCert);
    }

    public static class Factory
    extends CommonCertificate.Factory<Certificate> {
    }
}

