/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.x509.attr;

import de.intarsys.asn1.common.GeneralNames;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.x509.CertificateSerialNumber;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERBitString;

public class IssuerSerial
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public GeneralNames getIssuer() {
        return (GeneralNames)GeneralNames.FACTORY.create(this.getValueHolder().getChild(0));
    }

    public DERBitString getIssuerUniqueId() {
        ASN1ValueHolder o = this.getValueHolder().getChild(2);
        return o == null ? null : o.toDERBitString();
    }

    public CertificateSerialNumber getSerial() {
        ASN1ValueHolder o = this.getValueHolder().getChild(1);
        return (CertificateSerialNumber)CertificateSerialNumber.FACTORY.create(o);
    }

    public void setIssuer(GeneralNames generalNames) {
        this.getValueHolder().setChild(0, generalNames);
    }

    public void setSerial(BigInteger certSerialNumber) {
        this.setSerial((CertificateSerialNumber)CertificateSerialNumber.FACTORY.create((ASN1Encodable)new ASN1Integer(certSerialNumber)));
    }

    public void setSerial(CertificateSerialNumber certSerialNumber) {
        this.getValueHolder().setChild(1, certSerialNumber);
    }

    public static class Factory
    extends ASN1Based.Factory<IssuerSerial> {
    }
}

