/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.signme.app.signature;

import de.bdr.signme.api.v2.ApiSession;
import de.bdr.signme.api.v2.ECDSAChallengeSigner;
import de.bdr.signme.api.v2.gen.SignatureProcess;
import de.intarsys.asn1.cms.SignerInfo;
import de.intarsys.asn1.cms.UnsignedAttributes;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.CommonBatchSigner;
import de.intarsys.security.app.signature.SignatureItemEvidence;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.common.CommonSecurityException;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.signme.app.signature.PACKAGE;
import de.intarsys.security.device.signme.common.SignMeOutcomeConsumer;
import de.intarsys.security.device.signme.device.SignMeDevice;
import de.intarsys.security.device.signme.device.SignMePrincipal;
import de.intarsys.security.encoding.PSSEncoding;
import de.intarsys.security.method.cms.attribute.decoder.SignatureTimestampDecoder;
import de.intarsys.security.method.cms.signature.CMSSignature;
import de.intarsys.security.method.common.signature.SignatureOptions;
import de.intarsys.security.signature.attribute.ISignatureTimestampAttribute;
import de.intarsys.security.signature.common.ExtendedSignatureData;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.security.signature.common.SignatureTask;
import de.intarsys.security.signature.etsi.api.SignatureFormat;
import de.intarsys.security.signme.activity.SignMePortalGuardedSignActivity;
import de.intarsys.security.signme.common.PartnerAccess;
import de.intarsys.security.signme.common.SignMeSealingLevel;
import de.intarsys.security.signme.common.SignMeSignatureFormat;
import de.intarsys.security.signme.common.SignMeSignatureLevel;
import de.intarsys.security.signme.common.SignMeTools;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.tools.activity.IInteraction;
import de.intarsys.tools.concurrent.ICompletable;
import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.concurrent.TaskCallbackAdapter;
import de.intarsys.tools.concurrent.TaskFailed;
import de.intarsys.tools.conversation.ConversationRegistry;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.conversation.impl.ProcessingStage;
import de.intarsys.tools.conversation.service.impl.ConversationServiceTools;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.exception.TunnelingException;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.zones.Zone;
import java.nio.charset.StandardCharsets;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignMeSigner
extends CommonBatchSigner {
    private static final String CONV_SIGN_PREPARE = "signMePrepare";
    private static final String CONV_SIGN_COMMIT = "signMeCommit";
    private static final Logger Log = LoggerFactory.getLogger(SignMeSigner.class);
    public static final Collection<String> SUPPORTED_DIGEST_ALGORITHMS = Arrays.asList("SHA-256", "SHA-384", "SHA-512");
    private static final String ATTR_TAG = "tag";
    private SignMeSignatureFormat signMeSignatureFormat = SignMeSignatureFormat.CMS_BASIC;
    private IConversation<Void> conversationSignCommit;
    private SignMePortalGuardedSignActivity<?> signActivity;
    private final SignMePrincipal principal;
    private boolean basicCms;
    private boolean signatureProcessParamsChanged = false;
    private final ECDSAChallengeSigner challengeSigner;

    public SignMeSigner(SignMeDevice device, SignMePrincipal principal, ECDSAChallengeSigner challengeSigner) {
        super((CommonDevice)device);
        this.principal = principal;
        this.challengeSigner = challengeSigner;
    }

    protected void basicDispose() {
        super.basicDispose();
        IConversation<Void> tmpConversation = this.getConversationSignPrepare();
        if (tmpConversation != null) {
            tmpConversation.cancel(false);
        }
        if ((tmpConversation = this.getConversationSignCommit()) != null) {
            tmpConversation.cancel(false);
        }
    }

    protected IConversation<?> basicSignAuthorized() {
        try {
            List tempTasks = this.getTasks();
            if (tempTasks == null || tempTasks.isEmpty()) {
                return Conversation.completed(null);
            }
            this.basicSignCreateTaskNames(tempTasks);
            this.signActivity.signUpdate(tempTasks);
            this.proceedWithSign();
        }
        catch (Exception e) {
            CommonSecurityException tmpEx = SignMeTools.handleError((Throwable)e);
            this.getConversationSignCommit().completeExceptionally((Throwable)tmpEx);
        }
        return this.getConversationSignCommit();
    }

    protected void basicSignCreateTaskNames(List<SignatureTask> tempTasks) {
        Iterator iItemEvidence = this.getSignatureEvidence().getItems().iterator();
        int index = 0;
        for (SignatureTask task : tempTasks) {
            task.name = "Sign_Live_Document_" + index;
            if (iItemEvidence.hasNext()) {
                SignatureItemEvidence itemEvidence = (SignatureItemEvidence)iItemEvidence.next();
                task.name = itemEvidence.getLabel();
            }
            ++index;
        }
    }

    protected IConversation<Void> basicSignPrepare() {
        IConversation c = super.basicSignPrepare();
        if (this.getDevice().isEnrollmentEnabled() && !this.isSealingProcess()) {
            this.proceedWithRegistration((IConversation<Void>)c);
        } else {
            this.proceedWithSignatureProcess((IConversation<Void>)c);
        }
        return c;
    }

    protected IConversation<Void> basicSignTaskCheck(IToBeSignedData data) {
        return super.basicSignTaskCheck(data).thenAccept(ignore -> {
            boolean recreate = this.signMeSignatureProcessCheck();
            if (recreate) {
                if (this.tasksSize() > 0) {
                    throw new SecurityApplicationException("signature formats are incompatible");
                }
                try {
                    this.createSignatureProcess();
                }
                catch (Exception e) {
                    throw SignMeTools.handleError((Throwable)e);
                }
            }
        });
    }

    public void buildCertificatePath() {
        try {
            this.setCertificatePath(this.getPrincipal().getCertificatePath());
        }
        catch (SecurityApplicationException securityApplicationException) {
            // empty catch block
        }
    }

    protected ISignatureData convertSignature(byte[] response) {
        try {
            if (this.isBasic()) {
                ISignatureTimestampAttribute signatureTsAttr;
                ITimestampToken[] timestamps;
                Attribute asn1SignatureTsAttr;
                CMSSignature cmsSignature = new CMSSignature(response);
                SignerInfo signerInfo = cmsSignature.getSignerInfo(0);
                byte[] encodedSignature = signerInfo.getSignature().getBytes();
                ITimestampToken timestamp = null;
                UnsignedAttributes asn1UnsignedAttrs = cmsSignature.getUnsignedAttributes(0);
                if (asn1UnsignedAttrs != null && (asn1SignatureTsAttr = asn1UnsignedAttrs.get("1.2.840.113549.1.9.16.2.14")) != null && (timestamps = (signatureTsAttr = new SignatureTimestampDecoder().decodeAttribute((Object)asn1SignatureTsAttr)).getTimestamps()) != null && timestamps.length > 0) {
                    Log.debug("{} sign-me CMS contains timestamp", (Object)this);
                    timestamp = timestamps[0];
                }
                return ExtendedSignatureData.create((byte[])encodedSignature, timestamp);
            }
            return SignatureData.create((byte[])response);
        }
        catch (Exception e) {
            throw new TunnelingException((Throwable)e);
        }
    }

    protected AlgorithmParameterSpec createAlgorithmParameterSpec() {
        if (this.getHashAlgorithmName() == null) {
            return null;
        }
        if ("RSA".equals(this.getEncryptionAlgorithmName())) {
            return PSSEncoding.createPSSParameterSpec((String)this.getHashAlgorithmName());
        }
        return null;
    }

    protected IConversation<Void> createConversationSignCommit() {
        Conversation c = new Conversation(CONV_SIGN_COMMIT);
        ConversationRegistry.publishForLifetime((IConversation)c);
        return c;
    }

    protected IConversation<Void> createConversationSignPrepare() {
        Conversation c = new Conversation(CONV_SIGN_PREPARE);
        ConversationRegistry.publishForLifetime((IConversation)c);
        return c;
    }

    protected IPrincipal createPrincipal(IX509PublicKeyCertificate certificate) {
        return null;
    }

    protected String createRedirectParamValueAttributes(String value) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("tag: \"");
        sb.append(value);
        sb.append("\"}");
        String string = sb.toString();
        return Base64.getEncoder().encodeToString(string.getBytes(StandardCharsets.UTF_8));
    }

    protected void createSignatureProcess() throws Exception {
        SignatureProcess oldProcess = this.signActivity.getSignatureProcess();
        if (oldProcess != null) {
            this.getPartnerSession().cancelSignatureProcess(oldProcess.getSignatureProcessId());
            this.publish("signme.signatureProcess.canceled");
        }
        this.updateRedirectParamsState(this.signActivity, this.getConversationSignCommit());
        SignatureProcess process = this.signActivity.signPrepare();
        this.getPrincipal().setCertificatePath(this.signActivity.getCertificatePath());
        this.buildCertificatePath();
        this.publishPropertyPut("signatureProcessId", process.getSignatureProcessId());
        this.publish("signme.signatureProcess.created");
    }

    protected SignatureTask createSignatureTask(IToBeSignedData data) {
        SignatureTask task = super.createSignatureTask(data);
        try {
            this.setHashAlgorithmName(data.getDigest().getAlgorithmName());
        }
        catch (Exception e) {
            task.conversation.completeExceptionally((Throwable)e);
        }
        return task;
    }

    protected PartnerAccess getAccess() {
        return this.getDevice().getPartnerAccess();
    }

    public ECDSAChallengeSigner getChallengeSigner() {
        return this.challengeSigner;
    }

    protected IConversation<Void> getConversationSignCommit() {
        return this.conversationSignCommit;
    }

    public SignMeDevice getDevice() {
        return (SignMeDevice)super.getDevice();
    }

    public String getEncryptionAlgorithmName() {
        return this.getPrincipal().getEncryptionAlgorithmName();
    }

    protected ApiSession getPartnerSession() {
        return this.getDevice().getPartnerAccess().getApiSession();
    }

    public SignMePrincipal getPrincipal() {
        return this.principal;
    }

    protected SignMeSignatureFormat getSignMeSignatureFormat() {
        return this.signMeSignatureFormat;
    }

    public Collection<String> getSupportedHashAlgorithmNames() {
        return SUPPORTED_DIGEST_ALGORITHMS;
    }

    public void init() {
        super.init();
        this.conversationSignCommit = this.createConversationSignCommit();
        this.signActivity = new SignMePortalGuardedSignActivity();
        this.signActivity.setSession(this.getPartnerSession());
        this.signActivity.setQueryString(this.getDevice().getQueryStringSignature());
        this.signActivity.setQueryStringRegistration(this.getDevice().getQueryStringRegistration());
        this.signActivity.setQueryStringVerification(this.getDevice().getQueryStringVerification());
        this.signActivity.setIdentityVerificationType(this.getDevice().getIdentityVerificationType());
        this.signActivity.setCheckConfirmationEmail(this.getDevice().isCheckConfirmationEmail());
        this.signActivity.setRedirectUriProvider(this.getDevice().getRedirectUriProvider());
        this.signActivity.setUsername(this.getPrincipal().getUsername());
        this.signActivity.setSignerStatus(this.getPrincipal().getStatus());
        this.signActivity.setSignatureLevel(this.getPrincipal().getSignatureLevel());
        this.signActivity.setChallengeSigner(this.getChallengeSigner());
        this.signActivity.addTaskCallback((ITaskCallback)new TaskCallbackAdapter<List<byte[]>>(){

            protected void onFailedCancellation(TaskFailed exception) {
                SignMeSigner.this.publish("signme.signatureProcess.cancel");
                IConversation<Void> tmpConversation = SignMeSigner.this.getConversationSignPrepare();
                if (tmpConversation != null) {
                    tmpConversation.cancel(false);
                }
                if ((tmpConversation = SignMeSigner.this.getConversationSignCommit()) != null) {
                    tmpConversation.cancel(false);
                }
            }

            protected void onFailedException(TaskFailed exception) {
                Throwable unwrapped = ExceptionTools.unwrap((Throwable)exception);
                SignMeSigner.this.publish("signme.signatureProcess.fail");
                IConversation<Void> tmpConversation = SignMeSigner.this.getConversationSignPrepare();
                if (tmpConversation != null) {
                    tmpConversation.completeExceptionally(unwrapped);
                }
                if ((tmpConversation = SignMeSigner.this.getConversationSignCommit()) != null) {
                    tmpConversation.completeExceptionally(unwrapped);
                }
            }

            protected void onFinished(List<byte[]> result) {
                try {
                    SignMeSigner.this.publish("signme.signatureProcess.ok");
                    List<ISignatureData> signatures = result.stream().map(signature -> SignMeSigner.this.convertSignature((byte[])signature)).toList();
                    SignMeSigner.this.tasksComplete(signatures);
                    SignMeSigner.this.getConversationSignCommit().complete(null);
                }
                catch (Exception e) {
                    SignMeSigner.this.getConversationSignCommit().completeExceptionally((Throwable)e);
                }
            }
        });
    }

    public boolean isBasic() {
        return this.getSignMeSignatureFormat().isBasic();
    }

    public boolean isBasicCms() {
        return this.basicCms;
    }

    protected boolean isSealingProcess() {
        return this.getPrincipal() != null && this.getPrincipal().getSignatureLevel().isSealing();
    }

    protected void proceedWithPoll() {
        Log.debug("{} proceedWithPoll", (Object)this);
        this.updateRedirectParamsState(this.signActivity, this.getConversationSignCommit());
        ProcessingStage replyStage = new ProcessingStage(this.getProcessingMessageExpanded());
        Consumer ack = Zone.getCurrent().wrap(response -> this.signActivity.checkSignatureProcessState());
        replyStage.onAck(ack);
        this.getConversationSignCommit().setReplyStage((IReplyStage)replyStage);
        this.signActivity.checkSignatureProcessState();
    }

    protected void proceedWithRegistration(IConversation<Void> c) {
        this.updateRedirectParamsState(this.signActivity, c);
        IInteraction interaction = this.signActivity.enterRegistrationInteraction();
        interaction.getStage().thenAccept(result -> this.proceedWithVerification(c)).exceptionally(ex -> {
            this.signActivity.fail((Throwable)SignMeTools.handleError((Throwable)ex));
            return null;
        });
        if (!interaction.getCompletable().isDone()) {
            String processUrl = this.signActivity.getRegistrationInteractionUrl();
            boolean oob = this.signActivity.getRedirectUriProvider() == null || this.getDevice().isRegistrationOutOfBand();
            ConversationServiceTools.setOobActive(c, (boolean)oob);
            HttpRedirectStage stage = new HttpRedirectStage(processUrl, oob, false);
            stage.setName(this.getDevice().getRegistrationWindowName());
            stage.setSpecs(this.getDevice().getRegistrationWindowSpecs());
            String msg = PACKAGE.Messages.getString("SignMeSigner.registration.processing.message", new Object[0]);
            stage.onAck((Consumer)((Object)new SignMeOutcomeConsumer(msg, c, (ICompletable<Void>)interaction.getCompletable())));
            c.setReplyStage((IReplyStage)stage);
        }
    }

    protected void proceedWithSign() {
        this.updateRedirectParamsState(this.signActivity, this.getConversationSignCommit());
        IInteraction interaction = this.signActivity.enterConsentInteraction();
        interaction.getStage().thenAccept(result -> this.proceedWithPoll()).exceptionally(ex -> {
            this.signActivity.fail((Throwable)SignMeTools.handleError((Throwable)ex));
            return null;
        });
        if (!interaction.getCompletable().isDone()) {
            String processUrl = this.signActivity.getConsentInteractionUrl();
            boolean oob = this.signActivity.getRedirectUriProvider() == null || this.getDevice().isConsentOutOfBand();
            ConversationServiceTools.setOobActive(this.getConversationSignCommit(), (boolean)oob);
            HttpRedirectStage stage = new HttpRedirectStage(processUrl, oob, false);
            stage.setName(this.getDevice().getConsentWindowName());
            stage.setSpecs(this.getDevice().getConsentWindowSpecs());
            stage.onAck((Consumer)((Object)new SignMeOutcomeConsumer(this.getProcessingMessageExpanded(), this.getConversationSignCommit(), (ICompletable<Void>)interaction.getCompletable())));
            this.getConversationSignCommit().setReplyStage((IReplyStage)stage);
        }
    }

    protected void proceedWithSignatureProcess(IConversation<Void> c) {
        try {
            this.createSignatureProcess();
            c.complete(null);
        }
        catch (Exception e) {
            this.signActivity.fail((Throwable)SignMeTools.handleError((Throwable)e));
        }
    }

    protected void proceedWithVerification(IConversation<Void> c) {
        this.updateRedirectParamsAttributes(this.signActivity, c);
        IInteraction interaction = this.signActivity.enterVerificationInteraction();
        CompletionStage<Void> completionStage = interaction.getStage();
        if (!interaction.getCompletable().isDone()) {
            this.publishPropertyPut("verificationProcessId", this.signActivity.getIdentityVerificationProcessId());
            this.publish("signme.verificationProcess.created");
            String processUrl = this.signActivity.getIdentityVerificationInteractionUrl();
            boolean oob = this.signActivity.getRedirectUriProvider() == null || this.getDevice().isVerificationOutOfBand();
            ConversationServiceTools.setOobActive(c, (boolean)oob);
            HttpRedirectStage stage = new HttpRedirectStage(processUrl, oob, false);
            stage.setName(this.getDevice().getVerificationWindowName());
            stage.setSpecs(this.getDevice().getVerificationWindowSpecs());
            String msg = PACKAGE.Messages.getString("SignMeSigner.verification.processing.message", new Object[0]);
            stage.onAck((Consumer)((Object)new SignMeOutcomeConsumer(msg, c, (ICompletable<Void>)interaction.getCompletable())));
            completionStage = completionStage.thenAccept(ignore -> this.publish("signme.verificationProcess.ok")).exceptionally(e -> {
                if (ExceptionTools.isCancellation((Throwable)e)) {
                    this.publish("signme.verificationProcess.cancel");
                } else {
                    this.publish("signme.verificationProcess.fail");
                }
                return null;
            });
            c.setReplyStage((IReplyStage)stage);
        }
        completionStage.thenAccept(result -> this.proceedWithSignatureProcess(c)).exceptionally(ex -> {
            this.signActivity.fail((Throwable)SignMeTools.handleError((Throwable)ex));
            return null;
        });
    }

    public void setBasicCms(boolean basicCms) {
        this.basicCms = basicCms;
    }

    public void setHashAlgorithmName(String hashAlgorithmName) throws SecurityApplicationException {
        super.setHashAlgorithmName(hashAlgorithmName);
        this.setAlgorithmParameterSpec(this.createAlgorithmParameterSpec());
    }

    public void setSignatureFormat(SignatureFormat family) {
        super.setSignatureFormat(family);
        this.signMeSignatureFormatUpdate();
    }

    public void setSignatureOptions(SignatureOptions signatureOptions) {
        super.setSignatureOptions(signatureOptions);
        this.signMeSignatureFormatUpdate();
    }

    protected void setSignMeSignatureFormat(SignMeSignatureFormat signatureFormat) {
        this.signMeSignatureFormat = signatureFormat;
        if (this.signActivity != null) {
            this.signActivity.setSignatureFormat(this.getSignMeSignatureFormat());
        }
    }

    protected void setTag(IConversation c, String tag) {
        c.setAttribute((Object)ATTR_TAG, (Object)tag);
    }

    protected synchronized void signMeSignatureFormatUpdate() {
        boolean addTimestamp = false;
        if (this.getSignatureOptions().isAddTimestamp() && !this.getSignatureOptions().hasTimestampCreator()) {
            boolean bl = addTimestamp = this.getPrincipal().getSignatureLevel() == SignMeSignatureLevel.QUALIFIED || this.getPrincipal().getSignatureLevel() == SignMeSealingLevel.QUALIFIED_SEAL;
        }
        SignMeSignatureFormat format = this.isBasicCms() ? (addTimestamp ? SignMeSignatureFormat.CMS_BASIC_T : SignMeSignatureFormat.CMS_BASIC) : (this.getSignatureFormat() == null ? (addTimestamp ? SignMeSignatureFormat.CADES_T : SignMeSignatureFormat.CADES) : (this.getSignatureFormat() == SignatureFormat.CAdES ? (addTimestamp ? SignMeSignatureFormat.CADES_T : SignMeSignatureFormat.CADES) : (this.getSignatureFormat() == SignatureFormat.PAdES ? (addTimestamp ? SignMeSignatureFormat.CADES4PADES_T : SignMeSignatureFormat.CADES4PADES) : (addTimestamp ? SignMeSignatureFormat.CMS_BASIC_T : SignMeSignatureFormat.CMS_BASIC))));
        SignMeSignatureFormat oldFormat = this.getSignMeSignatureFormat();
        if (!LangTools.equals((Object)oldFormat, (Object)format)) {
            this.signatureProcessParamsChanged = true;
        }
        this.setSignMeSignatureFormat(format);
    }

    protected synchronized boolean signMeSignatureProcessCheck() {
        SignatureProcess oldProcess = this.signActivity.getSignatureProcess();
        if (oldProcess == null || !this.signatureProcessParamsChanged) {
            return false;
        }
        this.signatureProcessParamsChanged = false;
        return true;
    }

    protected String tagDecode(String value) {
        return value;
    }

    protected String tagEncode(String value) {
        return value;
    }

    protected void updateRedirectParamsAttributes(SignMePortalGuardedSignActivity<?> signActivity, IConversation conversation) {
        String username = this.getPrincipal().getUsername();
        conversation.setAttribute((Object)ATTR_TAG, (Object)username);
        String tagValue = this.createRedirectParamValueAttributes(username);
        signActivity.setRedirectParamName("attributes");
        signActivity.setRedirectParamValue(tagValue);
    }

    protected void updateRedirectParamsState(SignMePortalGuardedSignActivity<?> signActivity, IConversation conversation) {
        String stateValue = conversation.getHandle();
        signActivity.setRedirectParamName("state");
        signActivity.setRedirectParamValue(stateValue);
    }
}

