/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.signme.app.signature;

import de.bdr.signme.api.v2.ECDSAChallengeSigner;
import de.intarsys.security.app.signature.CommonSignerFactory;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelector;
import de.intarsys.security.certificate.provider.CertificateProviderTools;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.standard.PreselectCertificateProvider;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.IPrincipalFilter;
import de.intarsys.security.device.common.CertificateIdentityPrincipalFilter;
import de.intarsys.security.device.common.PrincipalEqualityPrincipalFilter;
import de.intarsys.security.device.common.PrincipalFilterTools;
import de.intarsys.security.device.signme.app.signature.SignMeSigner;
import de.intarsys.security.device.signme.device.SignMeDevice;
import de.intarsys.security.device.signme.device.SignMePrincipal;
import de.intarsys.security.device.signme.device.SignMePrincipalFilter;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.util.Iterator;

public class SignMeSignerFactory
extends CommonSignerFactory<SignMeDevice, SignMeSigner> {
    public static final String ARG_BASICCMS = "basicCms";
    private static final String ARG_SIGNER_STORE = "signerStore";
    public static final String ARG_PRINCIPAL_FILTER = "principalFilter";
    public static final String ARG_USERNAME = "username";
    public static final String ARG_AUTH_TOKEN_PASSWORD = "authorization.tokenPassword";
    public static final String ARG_AUTH_TOKEN_ID = "authorization.tokenId";
    public static final String ARG_AUTH_ORG_NAME = "authorization.organizationName";

    protected SignMeSigner basicCreateApp(IArgs args) throws ObjectCreationException {
        SignMePrincipal principal = null;
        IPrincipalFilter principalFilter = this.getPrincipalFilter(args, ARG_PRINCIPAL_FILTER);
        if (principalFilter == null) {
            Object sid = args.get("signerIdentifier");
            if (sid instanceof IPrincipal) {
                principalFilter = new PrincipalEqualityPrincipalFilter((IPrincipal)((SignMePrincipal)((Object)sid)));
            } else {
                IX509PublicKeyCertificate certificate = this.getCertificate(args, "signerIdentifier");
                principalFilter = new CertificateIdentityPrincipalFilter((IX509Certificate)certificate);
            }
        }
        ECDSAChallengeSigner challengeSigner = null;
        String username = ArgTools.getString((IArgs)args, (String)ARG_USERNAME, null);
        String tokenId = ArgTools.getString((IArgs)args, (String)ARG_AUTH_TOKEN_ID, (String)"");
        if (!StringTools.isEmpty((String)tokenId)) {
            challengeSigner = new ECDSAChallengeSigner(((SignMeDevice)this.getDevice(args)).createTokenFile(tokenId), ArgTools.getString((IArgs)args, (String)ARG_AUTH_TOKEN_PASSWORD, (String)"").toCharArray(), ArgTools.getString((IArgs)args, (String)ARG_AUTH_ORG_NAME, (String)""));
            username = challengeSigner.getUsername();
        }
        SignMePrincipalFilter signMeFilter = new SignMePrincipalFilter(username, principalFilter);
        Iterator<IPrincipal> principals = ((SignMeDevice)this.getDevice(args)).listPrincipals(signMeFilter);
        if (!principals.hasNext()) {
            throw new ObjectCreationException("no principal found");
        }
        principal = (SignMePrincipal)principals.next();
        SignMeSigner app = new SignMeSigner((SignMeDevice)this.getDevice(args), principal, challengeSigner);
        app.setBasicCms(ArgTools.getBoolStrict((IArgs)args, (String)ARG_BASICCMS, (boolean)true));
        return app;
    }

    protected String getArgNamePassword() {
        return "signerPassword";
    }

    protected ICertificateProvider getCertificateProvider(IArgs args) throws ObjectCreationException {
        X509CertificateSelector selector = new X509CertificateSelector();
        selector.setHasPrivateKey(Boolean.valueOf(true));
        String username = ArgTools.getString((IArgs)args, (String)ARG_USERNAME, null);
        PreselectCertificateProvider defaultProvider = new PreselectCertificateProvider((IX509CertificateFilter)selector, ((SignMeDevice)this.getDevice(args)).getCertificateProvider(username));
        ICertificateProvider provider = CertificateProviderTools.getCertificateProvider((IArgs)args, (String)ARG_SIGNER_STORE, (ICertificateProvider)defaultProvider);
        return provider;
    }

    protected IPrincipalFilter getPrincipalFilter(IArgs args, String name) throws ObjectCreationException {
        Object value = args.get(name);
        return PrincipalFilterTools.createFilter((Object)value);
    }

    public Class<SignMeSigner> getResultType() {
        return SignMeSigner.class;
    }
}

