/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.signme.common;

import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.signme.device.SignMeDeviceProvider;
import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.IPreferencesSyncher;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.preferences.PreferencesTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SingletonClass
public class SignMeEnvironment
implements IPreferencesSupport,
IPreferencesSyncher {
    private static final Logger Log = LoggerFactory.getLogger(SignMeEnvironment.class);
    private static final SignMeEnvironment ACTIVE = new SignMeEnvironment();
    public static final String PREF_ENDPOINT = "endpoint";
    public static final String PREF_ENDPOINT_ADDRESS = "address";
    public static final String PREF_ENDPOINT_ADDRESS_DEFAULT = "https://cloud-ref-sp.sign-me.de:443/api/v2";
    public static final String PREF_ENDPOINT_USER = "user";
    public static final String PREF_ENDPOINT_PASSWORD = "password";
    public static final String PREF_PARTNER = "partner";
    public static final String PREF_PARTNER_USER = "user";
    public static final String PREF_PARTNER_PASSWORD = "password";
    public static final String PREF_PARTNER_ROLE = "role";
    public static final String PREF_PARTNER_ROLE_DEFAULT = "PARTNER";
    private IPreferences preferences;
    private String deviceId = "id";

    public static SignMeEnvironment get() {
        return ACTIVE;
    }

    private SignMeEnvironment() {
    }

    protected IPreferences createPreferences() {
        IPreferences root = PreferencesFactory.get().getRoot();
        IPreferences tmpPreferences = root.node(this.getPreferencesName());
        this.preferencesInit(tmpPreferences.restrict("DEFAULT"));
        return tmpPreferences;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getEndpointAddress() {
        return this.getEndpointPreferences().get(PREF_ENDPOINT_ADDRESS, PREF_ENDPOINT_ADDRESS_DEFAULT);
    }

    public Secret getEndpointPassword() {
        return PreferencesTools.getSecret((IPreferences)this.getEndpointPreferences(), (String)"password", null);
    }

    protected IPreferences getEndpointPreferences() {
        return this.getPreferences().node(PREF_ENDPOINT);
    }

    public String getEndpointUser() {
        return this.getEndpointPreferences().get("user", null);
    }

    public Secret getPartnerPassword() {
        return PreferencesTools.getSecret((IPreferences)this.getPartnerPreferences(), (String)"password", null);
    }

    protected IPreferences getPartnerPreferences() {
        return this.getPreferences().node(PREF_PARTNER);
    }

    public String getPartnerRole() {
        return this.getPartnerPreferences().get(PREF_PARTNER_ROLE, null);
    }

    public String getPartnerUser() {
        return this.getPartnerPreferences().get("user", null);
    }

    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return "de.intarsys.prefs.security.signme";
    }

    @PostConstruct
    public void init() {
        this.registerDefault();
    }

    protected void preferencesInit(IPreferences preferences) {
        IPreferences nEndpoint = preferences.node(PREF_ENDPOINT);
        nEndpoint.put(PREF_ENDPOINT_ADDRESS, PREF_ENDPOINT_ADDRESS_DEFAULT);
        IPreferences nPartner = preferences.node(PREF_PARTNER);
        nPartner.put(PREF_PARTNER_ROLE, PREF_PARTNER_ROLE_DEFAULT);
    }

    public void preferencesRestore() {
    }

    public void preferencesStore() {
    }

    protected void registerDefault() {
        if (StringTools.isEmpty((String)this.getPartnerUser())) {
            return;
        }
        Log.info("{} create '{}' sign-me device from environment", (Object)this, (Object)this.getDeviceId());
        SignMeDeviceProvider deviceProvider = (SignMeDeviceProvider)((Object)DeviceTools.lookupDeviceProvider(SignMeDeviceProvider.class));
        Args args = Args.create();
        args.put("id", (Object)this.getDeviceId());
        Args service = Args.create();
        service.put(PREF_ENDPOINT_ADDRESS, (Object)this.getEndpointAddress());
        service.put("username", (Object)this.getEndpointUser());
        service.put("password", (Object)this.getEndpointPassword());
        args.put("service", (Object)service);
        Args partner = Args.create();
        partner.put("username", (Object)this.getPartnerUser());
        partner.put("password", (Object)this.getPartnerPassword());
        partner.put(PREF_PARTNER_ROLE, (Object)this.getPartnerRole());
        args.put(PREF_PARTNER, (Object)partner);
        try {
            deviceProvider.createInstance((IArgs)args);
        }
        catch (ObjectCreationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setEndpointAddress(String address) {
        this.getEndpointPreferences().put(PREF_ENDPOINT_ADDRESS, address);
    }

    public void setEndpointPassword(String password) {
        PreferencesTools.putSecret((IPreferences)this.getEndpointPreferences(), (String)"password", (Secret)Secret.hide((char[])password.toCharArray()));
    }

    public void setEndpointUser(String user) {
        this.getEndpointPreferences().put("user", user);
    }

    public void setPartnerPassword(String password) {
        PreferencesTools.putSecret((IPreferences)this.getPartnerPreferences(), (String)"password", (Secret)Secret.hide((char[])password.toCharArray()));
    }

    public void setPartnerRole(String role) {
        this.getPartnerPreferences().put(PREF_PARTNER_ROLE, role);
    }

    public void setPartnerUser(String user) {
        this.getPartnerPreferences().put("user", user);
    }
}

