/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.signme.common;

import de.intarsys.conversation.service.component.api.OutcomeConsumer;
import de.intarsys.security.device.signme.common.PACKAGE;
import de.intarsys.tools.concurrent.ICompletable;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.ProcessingStage;
import de.intarsys.tools.message.IMessageBundle;
import java.util.function.Consumer;

public class SignMeOutcomeConsumer
extends OutcomeConsumer {
    private static IMessageBundle Msg = PACKAGE.Messages;
    private final ICompletable<Void> completable;
    private final String progressMessage;

    public SignMeOutcomeConsumer(String progressMessage, IConversation conversation, ICompletable<Void> completable) {
        super(conversation);
        this.progressMessage = progressMessage;
        this.completable = completable;
    }

    protected void cancel() {
        this.completable.cancel(false);
    }

    protected void empty() {
        ProcessingStage nextStage = new ProcessingStage(this.getProgressMessage());
        nextStage.onAck((Consumer)((Object)this));
        this.getConversation().setReplyStage((IReplyStage)nextStage);
    }

    protected void fail() {
        String msg = Msg.getString("SignMeOutcomeConsumer.error.portalProcessFailed", new Object[0]);
        this.completable.fail((Throwable)new RuntimeException(msg));
    }

    public String getProgressMessage() {
        return this.progressMessage;
    }

    protected void ok() {
        this.completable.finish();
    }

    protected void unknown(Object value) {
        IllegalArgumentException ex = new IllegalArgumentException("unknown outcome " + value);
        this.completable.fail((Throwable)ex);
    }
}

