/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.signme.device;

import de.bdr.signme.api.v2.ApiSession;
import de.bdr.signme.api.v2.gen.Certificate;
import de.bdr.signme.api.v2.gen.SignMeException;
import de.bdr.signme.api.v2.gen.SignerStatus;
import de.bdr.signme.api.v2.gen.VersionAndDate;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.IPrincipalFilter;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.signme.device.SignMeDeviceCertificateProvider;
import de.intarsys.security.device.signme.device.SignMeDeviceProvider;
import de.intarsys.security.device.signme.device.SignMePrincipal;
import de.intarsys.security.device.signme.device.SignMePrincipalFilter;
import de.intarsys.security.signme.common.ISignMeLevel;
import de.intarsys.security.signme.common.IdentityVerificationType;
import de.intarsys.security.signme.common.PartnerAccess;
import de.intarsys.security.signme.common.SignMeSealingLevel;
import de.intarsys.security.signme.common.SignMeSignatureFormat;
import de.intarsys.security.signme.common.SignMeSignatureLevel;
import de.intarsys.security.signme.common.SignMeTools;
import de.intarsys.tools.collection.FailedIterator;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.FactoredBy;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.net.IUriProvider;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FactoredBy(factory=SignMeDeviceProvider.class)
public class SignMeDevice
extends CommonDevice<SignMeDeviceProvider> {
    private static final Logger Log = LoggerFactory.getLogger(SignMeDevice.class);
    public static final String LIC_PRODUCT = "de.intarsys.security.device.signme";
    private IUriProvider redirectUriProvider;
    @Deprecated
    private IUriProvider captureUriProvider;
    private PartnerAccess partnerAccess;
    private ICertificateProvider certificateProvider;
    private String consentWindowName;
    private String consentWindowSpecs;
    private String registrationWindowName;
    private String registrationWindowSpecs;
    private String verificationWindowName;
    private String verificationWindowSpecs;
    private boolean consentOutOfBand;
    private boolean registrationOutOfBand;
    private boolean verificationOutOfBand;
    private boolean checkConfirmationEmail = false;
    private boolean enrollmentEnabled = true;
    private IdentityVerificationType identityVerificationType;
    private String queryStringVerification = "USERNAME=${username}";
    private String queryStringSignature = "USERNAME=${username}";
    private String queryStringRegistration = "EMRO=true";
    private String tokenPath;

    protected SignMeDevice(SignMeDeviceProvider deviceProvider, String name) {
        super((CommonDeviceProvider)deviceProvider, name);
    }

    public void configure(IArgs args) throws Exception {
        super.configure(args);
        PartnerAccess access = ((SignMeDeviceProvider)this.getDeviceProvider()).getPartnerAccess(args);
        this.setPartnerAccess(access);
        this.setRedirectUriProvider((IUriProvider)ArgTools.getObject((IArgs)args, (String)"redirectUriProvider", (Object)ArgTools.getObject((IArgs)args, (String)"callbackUriProvider", null)));
        this.setQueryStringSignature(ArgTools.getString((IArgs)args, (String)"queryStringSignature", (String)this.getQueryStringSignature()));
        this.setQueryStringRegistration(ArgTools.getString((IArgs)args, (String)"queryStringRegistration", (String)this.getQueryStringRegistration()));
        this.setQueryStringVerification(ArgTools.getString((IArgs)args, (String)"queryStringVerification", (String)this.getQueryStringVerification()));
        this.setConsentWindowName(ArgTools.getString((IArgs)args, (String)"consentWindowName", null));
        this.setConsentWindowSpecs(ArgTools.getString((IArgs)args, (String)"consentWindowSpecs", null));
        this.setConsentOutOfBand(ArgTools.getBoolStrict((IArgs)args, (String)"consentOutOfBand", (boolean)false));
        this.setRegistrationOutOfBand(ArgTools.getBoolStrict((IArgs)args, (String)"registrationOutOfBand", (boolean)this.isConsentOutOfBand()));
        this.setRegistrationWindowName(ArgTools.getString((IArgs)args, (String)"registrationWindowName", (String)this.getConsentWindowName()));
        this.setRegistrationWindowSpecs(ArgTools.getString((IArgs)args, (String)"registrationWindowSpecs", (String)this.getConsentWindowSpecs()));
        this.setVerificationOutOfBand(ArgTools.getBoolStrict((IArgs)args, (String)"verificationOutOfBand", (boolean)this.isConsentOutOfBand()));
        this.setVerificationWindowName(ArgTools.getString((IArgs)args, (String)"verificationWindowName", (String)this.getConsentWindowName()));
        this.setVerificationWindowSpecs(ArgTools.getString((IArgs)args, (String)"verificationWindowSpecs", (String)this.getConsentWindowSpecs()));
        this.setEnrollmentEnabled(ArgTools.getBoolStrict((IArgs)args, (String)"enrollment.enabled", (boolean)true));
        this.setCheckConfirmationEmail(ArgTools.getBoolStrict((IArgs)args, (String)"enrollment.checkConfirmationEmail", (boolean)false));
        this.setIdentityVerificationType(IdentityVerificationType.create((String)ArgTools.getString((IArgs)args, (String)"enrollment.identityVerificationType", (String)IdentityVerificationType.FT_E_ID.getName())));
        if (!this.getIdentityVerificationType().isOfficial()) {
            Log.warn("{} is using non-official identity verification type {}", (Object)this, (Object)this.getIdentityVerificationType());
        }
        this.setTokenPath(ArgTools.getString((IArgs)args, (String)"authorization.tokenPath", null));
        if (StringTools.isEmpty((String)this.getTokenPath())) {
            this.setTokenPath(PathTools.join((String[])new String[]{FileEnvironment.get().getProfileDir().toString(), "devices", ((SignMeDeviceProvider)this.getDeviceProvider()).getId(), this.getId(), "authorization-tokens"}));
        }
    }

    protected IX509PublicKeyCertificate[] createCertificateChain(String certificateId) throws SecurityApplicationException {
        List<Certificate> certificates = this.signMeGetCertificateChain(certificateId);
        return (IX509PublicKeyCertificate[])certificates.stream().map(cert -> cert.getCertificate()).map(bytes -> {
            try {
                return X509CertificateFactory.get().createCertificate(bytes);
            }
            catch (CertificateException e) {
                throw ExceptionTools.wrap((Throwable)e);
            }
        }).toArray(IX509PublicKeyCertificate[]::new);
    }

    public File createTokenFile(String tokenId) {
        return new File(PathTools.join((String[])new String[]{this.getTokenPath(), tokenId}));
    }

    public IUriProvider getCaptureUriProvider() {
        return this.captureUriProvider;
    }

    public ICertificateProvider getCertificateProvider(String username) {
        if (this.certificateProvider == null) {
            this.certificateProvider = new SignMeDeviceCertificateProvider(this, username);
        }
        return this.certificateProvider;
    }

    public String getConsentWindowName() {
        return this.consentWindowName;
    }

    public String getConsentWindowSpecs() {
        return this.consentWindowSpecs;
    }

    public IdentityVerificationType getIdentityVerificationType() {
        return this.identityVerificationType;
    }

    public PartnerAccess getPartnerAccess() {
        return this.partnerAccess;
    }

    public ApiSession getPartnerSession() {
        return this.getPartnerAccess().getApiSession();
    }

    public String getQueryStringRegistration() {
        return this.queryStringRegistration;
    }

    public String getQueryStringSignature() {
        return this.queryStringSignature;
    }

    public String getQueryStringVerification() {
        return this.queryStringVerification;
    }

    public IUriProvider getRedirectUriProvider() {
        return this.redirectUriProvider;
    }

    public String getRegistrationWindowName() {
        return this.registrationWindowName;
    }

    public String getRegistrationWindowSpecs() {
        return this.registrationWindowSpecs;
    }

    public String getTokenPath() {
        return this.tokenPath;
    }

    public String getVerificationWindowName() {
        return this.verificationWindowName;
    }

    public String getVerificationWindowSpecs() {
        return this.verificationWindowSpecs;
    }

    protected void initBasic() throws Exception {
        super.initBasic();
        this.getPartnerAccess().login();
        VersionAndDate version = this.signMeGetVersion();
        Log.info("{} version {}-{}", new Object[]{this, version.getVersion(), version.getDate()});
    }

    public boolean isCheckConfirmationEmail() {
        return this.checkConfirmationEmail;
    }

    public boolean isConsentOutOfBand() {
        return this.consentOutOfBand;
    }

    public boolean isEnrollmentEnabled() {
        return this.enrollmentEnabled;
    }

    public boolean isRegistrationOutOfBand() {
        return this.registrationOutOfBand;
    }

    public boolean isVerificationOutOfBand() {
        return this.verificationOutOfBand;
    }

    public Iterator<IPrincipal> listPrincipals(IPrincipalFilter filter) {
        try {
            ArrayList<IPrincipal> principals = new ArrayList<IPrincipal>();
            if (filter instanceof SignMePrincipalFilter) {
                SignMePrincipalFilter tempFilter = (SignMePrincipalFilter)filter;
                String username = tempFilter.getUsername();
                this.listPrincipalsAdd(principals, username, (ISignMeLevel)SignMeSignatureLevel.QUALIFIED, filter);
                this.listPrincipalsAdd(principals, username, (ISignMeLevel)SignMeSignatureLevel.ADVANCED, filter);
                this.listPrincipalsAdd(principals, username, (ISignMeLevel)SignMeSignatureLevel.BASIC, filter);
                this.listPrincipalsAdd(principals, username, (ISignMeLevel)SignMeSealingLevel.QUALIFIED_SEAL, filter);
            }
            return principals.iterator();
        }
        catch (Exception e) {
            return new FailedIterator((Throwable)e);
        }
    }

    protected void listPrincipalsAdd(List<IPrincipal> principals, String username, ISignMeLevel level, IPrincipalFilter filter) throws SecurityApplicationException {
        SignMePrincipal principal;
        SignMeSignatureFormat format = SignMeSignatureFormat.CADES;
        String signatureType = SignMeTools.getSignatureTypeDigest((ISignMeLevel)level, (SignMeSignatureFormat)format);
        SignerStatus status = null;
        if (!level.isSealing()) {
            status = this.signMeGetSignerStatus(username, signatureType);
        }
        if (filter.accept((IPrincipal)(principal = new SignMePrincipal((IDevice)this, username, level, status)))) {
            principals.add((IPrincipal)principal);
        }
    }

    public void setCaptureUriProvider(IUriProvider captureUriProvider) {
        this.captureUriProvider = captureUriProvider;
    }

    public void setCheckConfirmationEmail(boolean checkConfirmationEmail) {
        this.checkConfirmationEmail = checkConfirmationEmail;
    }

    public void setConsentOutOfBand(boolean consentOutOfBand) {
        this.consentOutOfBand = consentOutOfBand;
    }

    public void setConsentWindowName(String consentWindowName) {
        this.consentWindowName = consentWindowName;
    }

    public void setConsentWindowSpecs(String consentWindowSpecs) {
        this.consentWindowSpecs = consentWindowSpecs;
    }

    public void setEnrollmentEnabled(boolean enrollmentEnabled) {
        this.enrollmentEnabled = enrollmentEnabled;
    }

    public void setIdentityVerificationType(IdentityVerificationType identityVerificationType) {
        this.identityVerificationType = identityVerificationType;
    }

    public void setPartnerAccess(PartnerAccess access) {
        this.partnerAccess = access;
    }

    public void setQueryStringRegistration(String queryStringRegistration) {
        this.queryStringRegistration = queryStringRegistration;
    }

    public void setQueryStringSignature(String queryStringSignature) {
        this.queryStringSignature = queryStringSignature;
    }

    public void setQueryStringVerification(String queryStringVerification) {
        this.queryStringVerification = queryStringVerification;
    }

    public void setRedirectUriProvider(IUriProvider baseUriProvider) {
        this.redirectUriProvider = baseUriProvider;
    }

    public void setRegistrationOutOfBand(boolean registrationOutOfBand) {
        this.registrationOutOfBand = registrationOutOfBand;
    }

    public void setRegistrationWindowName(String registrationWindowName) {
        this.registrationWindowName = registrationWindowName;
    }

    public void setRegistrationWindowSpecs(String registrationWindowSpecs) {
        this.registrationWindowSpecs = registrationWindowSpecs;
    }

    public void setTokenPath(String tokenPath) {
        this.tokenPath = tokenPath;
    }

    public void setVerificationOutOfBand(boolean verificationOutOfBand) {
        this.verificationOutOfBand = verificationOutOfBand;
    }

    public void setVerificationWindowName(String verificationWindowName) {
        this.verificationWindowName = verificationWindowName;
    }

    public void setVerificationWindowSpecs(String verificationWindowSpecs) {
        this.verificationWindowSpecs = verificationWindowSpecs;
    }

    protected List<Certificate> signMeGetCertificateChain(String certificateId) throws SecurityApplicationException {
        try {
            return this.getPartnerSession().getCertificate(certificateId, true);
        }
        catch (Exception e) {
            throw new SecurityApplicationException((Throwable)e);
        }
    }

    protected SignerStatus signMeGetSignerStatus(String username, String signatureType) throws SecurityApplicationException {
        try {
            return this.getPartnerSession().getSignerStatus(signatureType, username, null, null);
        }
        catch (Exception e) {
            throw new SecurityApplicationException((Throwable)e);
        }
    }

    protected VersionAndDate signMeGetVersion() throws SignMeException {
        VersionAndDate version = this.getPartnerSession().getVersion();
        return version;
    }
}

