/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.signme.device;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.common.CommonCertificateProvider;
import de.intarsys.security.certificate.common.CommonX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.IServiceTypeSelector;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.device.IDeviceSupport;
import de.intarsys.security.device.IPrincipalFilter;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.signme.device.SignMeDeviceProvider;
import de.intarsys.security.device.signme.device.SignMePrincipal;
import de.intarsys.security.device.signme.device.SignMePrincipalFilter;
import de.intarsys.tools.collection.ConversionIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SignMeDeviceCertificateProvider
extends CommonCertificateProvider
implements IDeviceSupport {
    private final CommonDevice<SignMeDeviceProvider> device;
    private String username;

    public SignMeDeviceCertificateProvider(CommonDevice<SignMeDeviceProvider> device, String username) {
        this.device = device;
        this.username = username;
    }

    protected synchronized List<IX509Certificate> getCertificates(IX509CertificateSelector selector) {
        ArrayList<IX509Certificate> certificates = new ArrayList<IX509Certificate>();
        SignMePrincipalFilter signMeFilter = new SignMePrincipalFilter(this.getUsername(), null);
        Iterator principals = this.getDevice().listPrincipals((IPrincipalFilter)signMeFilter);
        if (principals != null && selector != null) {
            while (principals.hasNext()) {
                SignMePrincipal principal = (SignMePrincipal)((Object)principals.next());
                try {
                    IX509PublicKeyCertificate[] certificatePath = principal.getCertificatePath();
                    for (int i = 0; i < certificatePath.length; ++i) {
                        IX509PublicKeyCertificate certificate = certificatePath[i];
                        if (selector.hasPrivateKey() != null && selector.hasPrivateKey().booleanValue() && i != 0) continue;
                        certificates.add((IX509Certificate)certificate);
                    }
                }
                catch (SecurityApplicationException securityApplicationException) {
                }
            }
        }
        return certificates;
    }

    public CommonDevice<SignMeDeviceProvider> getDevice() {
        return this.device;
    }

    public String getUsername() {
        return this.username;
    }

    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        IX509CertificateSelector selector = null;
        if (filter instanceof IX509CertificateSelector) {
            IX509CertificateSelector cast = (IX509CertificateSelector)filter;
            selector = cast;
            if (Boolean.TRUE.equals(selector.isPrivateKeyAccessible())) {
                return Collections.emptyIterator();
            }
            IServiceTypeSelector serviceTypeSelector = selector.getServiceTypeSelector();
            if (serviceTypeSelector != null && serviceTypeSelector.isTrustedOnly()) {
                return Collections.emptyIterator();
            }
        }
        List<IX509Certificate> certificates = this.getCertificates(selector);
        Iterator i = CertificateTools.selectCertificates((IX509CertificateFilter)filter, certificates);
        return new ConversionIterator<IX509Certificate, IX509Certificate>(i){

            protected IX509Certificate createTargetObject(IX509Certificate sourceObject) {
                if (sourceObject instanceof CommonX509PublicKeyCertificate) {
                    CommonX509PublicKeyCertificate x509Cert = (CommonX509PublicKeyCertificate)sourceObject;
                    x509Cert.setCertificateProvider((ICertificateProvider)SignMeDeviceCertificateProvider.this);
                }
                return sourceObject;
            }
        };
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

