/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.signme.device;

import de.bdr.signme.api.v2.SignMeApiV2Client;
import de.bdr.signme.api.v2.SignMeApiV2Ext;
import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.signature.CommonSignerPolicy;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.signme.app.signature.SignMeSignerFactory;
import de.intarsys.security.device.signme.device.SignMeDevice;
import de.intarsys.security.signme.common.PartnerAccess;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.ssl.SslContextProvider;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;

public class SignMeDeviceProvider
extends CommonDeviceProvider<SignMeDevice> {
    public static final String ARG_SERVICE = "service";
    public static final String ARG_SERVICEADDRESS = "address";
    public static final String ARG_SERVICEUSERNAME = "username";
    public static final String ARG_SERVICEPASSWORD = "password";
    public static final String ARG_PARTNER = "partner";
    public static final String ARG_PARTNERUSERNAME = "username";
    public static final String ARG_PARTNERPASSWORD = "password";
    public static final String ARG_PARTNERROLE = "role";
    public static final String ARG_PERSONUSER = "personUser";
    private Map<String, PartnerAccess> partner2access = new HashMap<String, PartnerAccess>();

    protected SignMeDevice basicCreateInstance(IArgs args) {
        String id = ArgTools.getString((IArgs)args, (String)"id", null);
        SignMeDevice device = new SignMeDevice(this, id);
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PartnerAccess createPartnerAccess(IArgs args, SignMeApiV2Ext service) throws ObjectCreationException {
        String username = ArgTools.getString((IArgs)args, (String)"username", null);
        if (StringTools.isEmpty((String)username)) {
            throw new ObjectCreationException("'username' required");
        }
        Secret password = ArgTools.getSecretHide((IArgs)args, (String)"password", null);
        if (CryptoTools.isEmpty((Secret)password)) {
            throw new ObjectCreationException("'password' required");
        }
        String role = ArgTools.getString((IArgs)args, (String)ARG_PARTNERROLE, null);
        if (StringTools.isEmpty((String)role)) {
            throw new ObjectCreationException("'role' required");
        }
        if (service == null) {
            throw new ObjectCreationException("service account required");
        }
        String key = PartnerAccess.createKey((String)username, (String)role);
        Map<String, PartnerAccess> map = this.partner2access;
        synchronized (map) {
            PartnerAccess access = this.partner2access.get(key);
            if (access == null) {
                access = new PartnerAccess();
                access.setPartnerUser(username);
                access.setPartnerPassword(password);
                access.setPartnerRole(role);
                access.setSignMeApi(service);
                this.partner2access.put(key, access);
            }
            return access;
        }
    }

    protected SignMeApiV2Ext createService(IArgs args) throws ObjectCreationException {
        String address = ArgTools.getString((IArgs)args, (String)ARG_SERVICEADDRESS, null);
        if (StringTools.isEmpty((String)address)) {
            throw new ObjectCreationException("'address' required");
        }
        String username = ArgTools.getString((IArgs)args, (String)"username", null);
        if (StringTools.isEmpty((String)username)) {
            throw new ObjectCreationException("'username' required");
        }
        Secret password = ArgTools.getSecretHide((IArgs)args, (String)"password", null);
        if (CryptoTools.isEmpty((Secret)password)) {
            throw new ObjectCreationException("'password' required");
        }
        try {
            SSLContext sslContext = SslContextProvider.get().createSslContext();
            return SignMeApiV2Client.get((String)address, (String)username, (String)password.getString(), (SSLContext)sslContext);
        }
        catch (Exception e) {
            throw new ObjectCreationException((Throwable)e);
        }
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> apps) {
        super.declareApplicationDescriptors(apps);
        SignMeSignerFactory descriptor = new SignMeSignerFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setLicenseAccountSupplier(() -> this.declareLicenseAccountSign());
        CommonSignerPolicy signerPolicy = new CommonSignerPolicy((CommonDeviceProvider)this);
        descriptor.setPolicy((IApplicationPolicy)signerPolicy);
        descriptor.setType(ISigner.class);
        apps.add((IApplicationDescriptor)descriptor);
    }

    protected ILicenseAccount declareLicenseAccountSignBasic() {
        ILicenseAccount account = this.getLicenseProduct().getAccount("de.intarsys.security.app.sign.account");
        account.setDefaultValueUnit(10, LicensePropertyUnit.PER_MINUTE);
        return account;
    }

    protected LicenseProduct declareLicenseProduct() {
        return LicenseTools.createProduct((Object)((Object)this), (String)"de.intarsys.security.device.signme");
    }

    public PartnerAccess getPartnerAccess(IArgs args) throws ObjectCreationException {
        Object argsPartner = args.get(ARG_PARTNER);
        if (argsPartner == null) {
            throw new ObjectCreationException("'partner' required");
        }
        if (argsPartner instanceof PartnerAccess) {
            return (PartnerAccess)argsPartner;
        }
        if (argsPartner instanceof IArgs) {
            SignMeApiV2Ext service = this.getService(args);
            return this.createPartnerAccess((IArgs)argsPartner, service);
        }
        throw new ObjectCreationException("'partner' invalid");
    }

    public SignMeApiV2Ext getService(IArgs args) throws ObjectCreationException {
        Object serviceObj = args.get(ARG_SERVICE);
        if (serviceObj == null) {
            return null;
        }
        if (serviceObj instanceof SignMeApiV2Ext) {
            return (SignMeApiV2Ext)serviceObj;
        }
        if (serviceObj instanceof IArgs) {
            return this.createService((IArgs)serviceObj);
        }
        throw new ObjectCreationException("'service' invalid");
    }

    @PostConstruct
    public void init() {
        super.init();
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
    }
}

