/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.signme.device;

import de.bdr.signme.api.v2.ApiSession;
import de.bdr.signme.api.v2.gen.SignerStatus;
import de.bdr.signme.api.v2.gen.TokenCapability;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.common.CommonX509Principal;
import de.intarsys.security.device.signme.device.IssuerPrincipal;
import de.intarsys.security.device.signme.device.SignMeDevice;
import de.intarsys.security.device.signme.device.SignMePrincipalWrapper;
import de.intarsys.security.signme.common.ISignMeLevel;
import de.intarsys.security.signme.common.SignMeTools;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.facade.IFacade;
import de.intarsys.tools.facade.IFacadeSupport;
import de.intarsys.tools.lang.LangTools;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Optional;

public class SignMePrincipal
extends CommonX509Principal
implements IFacadeSupport {
    private final String username;
    private final SignerStatus status;
    private final ISignMeLevel signatureLevel;
    private IX509PublicKeyCertificate[] certificatePath;

    public SignMePrincipal(IDevice device, String username, ISignMeLevel level, SignerStatus status) {
        super(device, null, level.getId());
        this.username = username;
        this.signatureLevel = level;
        this.status = status;
    }

    protected IX509PublicKeyCertificate createCertificate() {
        try {
            IX509PublicKeyCertificate[] certs = this.getCertificatePath();
            if (certs.length > 0) {
                return certs[0];
            }
        }
        catch (SecurityApplicationException securityApplicationException) {
            // empty catch block
        }
        return null;
    }

    public IFacade createFacade() {
        return new SignMePrincipalWrapper((IPrincipal)this);
    }

    protected CommonX509Principal createIssuer() {
        IssuerPrincipal issuer = null;
        try {
            IX509PublicKeyCertificate[] chain = this.getCertificatePath();
            if (chain.length < 2) {
                return issuer;
            }
            for (int i = chain.length - 1; i > 0; --i) {
                IssuerPrincipal current;
                issuer = current = new IssuerPrincipal((IDevice)this.getDevice(), chain[i], issuer);
            }
        }
        catch (SecurityApplicationException securityApplicationException) {
            // empty catch block
        }
        return issuer;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SignMePrincipal)) {
            return false;
        }
        return LangTools.equals((Object)this.getSignatureLevel(), (Object)((SignMePrincipal)((Object)obj)).getSignatureLevel());
    }

    public IX509PublicKeyCertificate[] getCertificatePath() throws SecurityApplicationException {
        if (this.certificatePath == null) {
            try {
                Optional opt = SignMeTools.signMeGetToken((ApiSession)this.getDevice().getPartnerSession(), (String)this.username, (TokenCapability[])this.getSignatureLevel().getCapabilities());
                this.certificatePath = opt.map(token -> {
                    try {
                        return this.getDevice().createCertificateChain(token.getCertificateId());
                    }
                    catch (Exception e) {
                        throw ExceptionTools.wrap((Throwable)e);
                    }
                }).orElseGet(() -> new IX509PublicKeyCertificate[0]);
            }
            catch (Exception e) {
                throw (SecurityApplicationException)ExceptionTools.unwrapTypedFromChain((Throwable)e, SecurityApplicationException.class);
            }
        }
        return this.certificatePath;
    }

    public SignMeDevice getDevice() {
        return (SignMeDevice)super.getDevice();
    }

    public String getEncryptionAlgorithmName() {
        if (this.certificatePath == null || this.certificatePath.length == 0) {
            return this.getSignatureLevel().getDefaultEncryptionAlgorithmName();
        }
        IX509PublicKeyCertificate cert = this.certificatePath[0];
        PublicKey key = cert.getPublicKey();
        if (key instanceof ECPublicKey) {
            return "ECDSA";
        }
        if (key instanceof RSAPublicKey) {
            return "RSA";
        }
        return "ECDSA";
    }

    public ISignMeLevel getSignatureLevel() {
        return this.signatureLevel;
    }

    public SignerStatus getStatus() {
        return this.status;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean hasCapability(String capability) {
        TokenCapability tokenCapability = TokenCapability.valueOf((String)capability);
        for (TokenCapability aCapability : this.getSignatureLevel().getCapabilities()) {
            if (tokenCapability != aCapability) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.getSignatureLevel().hashCode();
    }

    public void setCertificatePath(IX509PublicKeyCertificate[] certificatePath) {
        this.certificatePath = certificatePath;
    }
}

