/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.decryption;

import de.intarsys.document.model.IDocument;
import de.intarsys.processor.document.common.CommonDocumentProcessor;
import de.intarsys.security.app.crypt.IDecryptedData;
import de.intarsys.security.processor.decryption.IDocumentDecryptor;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.file.MagicFileNumberTest;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.BasicLocatorFactory;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public abstract class CommonDocumentDecryptor
extends CommonDocumentProcessor
implements IDocumentDecryptor {
    protected static final String SUFFIX_TXT = "txt";
    protected static final String SUFFIX_UNKNOWN = "unknown";
    private IDecryptedData decryptedData;

    protected static ILocator createPersistentLocator(ILocator baseLocator) {
        ILocator parent = baseLocator.getParent();
        if (parent == null) {
            return CommonDocumentDecryptor.createTransientLocator(baseLocator);
        }
        String baseName = LocatorTools.getBaseName((ILocator)baseLocator);
        String targetName = PathTools.getBaseName((String)baseName);
        String targetExtension = PathTools.getExtension((String)baseName, null, (String)SUFFIX_UNKNOWN);
        return parent.getChild(targetName + "." + targetExtension);
    }

    protected static ILocator createTransientLocator(ILocator baseLocator) {
        String baseName = LocatorTools.getBaseName((ILocator)baseLocator);
        String targetName = PathTools.getBaseName((String)baseName);
        String targetExtension = PathTools.getExtension((String)baseName, null, (String)SUFFIX_UNKNOWN);
        ByteArrayLocator targetLocator = new ByteArrayLocator(null, targetName, targetExtension);
        return targetLocator;
    }

    public static ILocator getLocator(IArgs args, final IDocument document) {
        ILocator locator = ArgTools.getLocator((IArgs)args, (String)"locator", null, (ILocatorFactory)new ILocatorFactory(){

            public ILocator createLocator(String location) throws IOException {
                File tempFile = new File(location);
                if (tempFile.isAbsolute()) {
                    return new FileLocator(tempFile);
                }
                if (document.getLocator().getParent() != null) {
                    return document.getLocator().getParent().getChild(location);
                }
                return BasicLocatorFactory.get().createLocator(location);
            }
        });
        if (locator == null) {
            locator = CommonDocumentDecryptor.isTransient(args) ? CommonDocumentDecryptor.createTransientLocator(document.getLocator()) : CommonDocumentDecryptor.createPersistentLocator(document.getLocator());
        }
        return locator;
    }

    public static boolean isTransient(IArgs args) {
        return ArgTools.getBoolStrict((IArgs)args, (String)"createTransient", (boolean)true);
    }

    public CommonDocumentDecryptor(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    protected Object basicGetResult() {
        return this.decryptedData;
    }

    protected void basicRun() throws Exception {
        ILocator targetLocator = CommonDocumentDecryptor.getLocator(this.getArgs(), this.getDocument());
        this.decryptedData = this.decrypt(this.getDocument(), targetLocator);
        String targetLocatorType = this.guessLocatorType(targetLocator);
        String extension = LocatorTools.getExtension((ILocator)targetLocator);
        if (!extension.equals(targetLocatorType)) {
            String basename = LocatorTools.getBaseName((ILocator)targetLocator);
            targetLocator.rename(basename + "." + targetLocatorType);
        }
        targetLocator.setReadOnly();
        this.ok();
    }

    protected abstract IDecryptedData decrypt(IDocument var1, ILocator var2) throws Exception;

    public IDecryptedData getDecryptedData() {
        return this.decryptedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String guessLocatorType(ILocator locator) throws IOException {
        if (!LocatorTools.getExtension((ILocator)locator).equals(SUFFIX_UNKNOWN)) {
            return LocatorTools.getExtension((ILocator)locator);
        }
        String typeGuess = null;
        IRandomAccess ra = null;
        try {
            ra = locator.getRandomAccess();
            typeGuess = MagicFileNumberTest.guessFileSuffix((IRandomAccess)ra);
            if (typeGuess == null && MagicFileNumberTest.isText((IRandomAccess)ra)) {
                typeGuess = SUFFIX_TXT;
            }
        }
        finally {
            StreamTools.close((Closeable)ra);
        }
        if (typeGuess == null) {
            typeGuess = LocatorTools.getExtension((ILocator)locator);
        }
        return typeGuess;
    }
}

