/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.decryption;

import de.intarsys.security.app.decryption.IDecryptor;
import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.IPreferencesSyncher;
import de.intarsys.tools.preferences.PreferencesFactory;

@SingletonClass
public class DecryptionEnvironment
implements IPreferencesSupport,
IPreferencesSyncher {
    private static final String PREFERENCES_NAME = "de.intarsys.prefs.security.crypt";
    public static final boolean DEFAULT_AUTO_SAVE_DOCUMENTS = false;
    public static final String PREF_AUTO_SAVE_DOCUMENTS = "auto_save_document";
    private static final DecryptionEnvironment ACTIVE = new DecryptionEnvironment();
    private IFactory[] decryptorFactories;
    private IPreferences preferences;

    public static DecryptionEnvironment get() {
        return ACTIVE;
    }

    private DecryptionEnvironment() {
    }

    protected IPreferences createPreferences() {
        String name = this.getPreferencesName();
        IPreferences root = PreferencesFactory.get().getRoot();
        IPreferences result = root.node(name);
        IPreferences defaultPreferences = result.restrict("DEFAULT");
        this.preferencesInit(defaultPreferences);
        return result;
    }

    public IFactory[] getDecryptorFactories() {
        if (this.decryptorFactories == null) {
            this.decryptorFactories = Outlet.get().lookupFactories(IDecryptor.class);
        }
        return this.decryptorFactories;
    }

    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return PREFERENCES_NAME;
    }

    public boolean isAutoSaveDocument() {
        return this.getPreferences().getBoolean(PREF_AUTO_SAVE_DOCUMENTS, false);
    }

    protected void preferencesInit(IPreferences preferences) {
        preferences.put(PREF_AUTO_SAVE_DOCUMENTS, false);
    }

    public void preferencesRestore() {
    }

    public void preferencesStore() {
    }

    public void setAutoSaveDocument(boolean autoSave) {
        this.getPreferences().put(PREF_AUTO_SAVE_DOCUMENTS, autoSave);
    }
}

