/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.encryption;

import de.intarsys.document.model.IDocument;
import de.intarsys.processor.document.common.CommonDocumentProcessor;
import de.intarsys.security.app.crypt.IEncryptedData;
import de.intarsys.security.processor.encryption.IDocumentEncryptor;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.BasicLocatorFactory;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import java.io.File;
import java.io.IOException;

public abstract class CommonDocumentEncryptor
extends CommonDocumentProcessor
implements IDocumentEncryptor {
    private IEncryptedData encryptedData;

    protected static ILocator createPersistentLocator(ILocator baseLocator, String extension) {
        ILocator parent = baseLocator.getParent();
        if (parent == null) {
            return CommonDocumentEncryptor.createTransientLocator(baseLocator, extension);
        }
        String baseName = baseLocator.getName();
        return parent.getChild(baseName + "." + extension);
    }

    protected static ILocator createTransientLocator(ILocator baseLocator, String extension) {
        String baseName = baseLocator.getName();
        ByteArrayLocator targetLocator = new ByteArrayLocator(null, baseName, extension);
        return targetLocator;
    }

    public static ILocator getLocator(IArgs args, final IDocument document, String extension) {
        ILocator locator = ArgTools.getLocator((IArgs)args, (String)"locator", null, (ILocatorFactory)new ILocatorFactory(){

            public ILocator createLocator(String location) throws IOException {
                File tempFile = new File(location.trim());
                if (tempFile.isAbsolute()) {
                    return new FileLocator(tempFile);
                }
                if (document.getLocator().getParent() != null) {
                    return document.getLocator().getParent().getChild(location);
                }
                return BasicLocatorFactory.get().createLocator(location);
            }
        });
        if (locator == null) {
            locator = CommonDocumentEncryptor.isTransient(args) ? CommonDocumentEncryptor.createTransientLocator(document.getLocator(), extension) : CommonDocumentEncryptor.createPersistentLocator(document.getLocator(), extension);
        }
        return locator;
    }

    public static boolean isTransient(IArgs args) {
        return ArgTools.getBoolStrict((IArgs)args, (String)"createTransient", (boolean)false);
    }

    public CommonDocumentEncryptor(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    protected Object basicGetResult() {
        return this.getEncryptedData();
    }

    protected void basicRun() throws Exception {
        ILocator targetLocator = CommonDocumentEncryptor.getLocator(this.getArgs(), this.getDocument(), this.getDefaultExtension());
        this.encryptedData = this.encrypt(this.getDocument(), targetLocator);
        this.ok();
    }

    protected abstract IEncryptedData encrypt(IDocument var1, ILocator var2) throws Exception;

    protected abstract String getDefaultExtension();

    public IEncryptedData getEncryptedData() {
        return this.encryptedData;
    }
}

