/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.encryption;

import de.intarsys.document.model.IDocumentType;
import de.intarsys.security.device.processor.IRecipientProvider;
import de.intarsys.security.processor.encryption.IDocumentEncryptor;
import de.intarsys.security.processor.encryption.IDocumentEncryptorFactory;
import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.IPreferencesSyncher;
import de.intarsys.tools.preferences.PreferencesFactory;
import java.util.ArrayList;

@SingletonClass
public class EncryptionEnvironment
implements IPreferencesSupport,
IPreferencesSyncher {
    private static final String PREFERENCES_NAME = "de.intarsys.prefs.security.crypt";
    public static final boolean DEFAULT_AUTO_SAVE_DOCUMENTS = false;
    public static final String PREF_AUTO_SAVE_DOCUMENTS = "auto_save_document";
    private static final EncryptionEnvironment ACTIVE = new EncryptionEnvironment();
    private IFactory[] documentEncryptorFactories;
    private IFactory[] encryptorFactories;
    private IPreferences preferences;

    public static EncryptionEnvironment get() {
        return ACTIVE;
    }

    private EncryptionEnvironment() {
    }

    protected IPreferences createPreferences() {
        String name = this.getPreferencesName();
        IPreferences root = PreferencesFactory.get().getRoot();
        IPreferences result = root.node(name);
        IPreferences defaultPreferences = result.restrict("DEFAULT");
        this.preferencesInit(defaultPreferences);
        return result;
    }

    public IFactory[] getDocumentEncryptorFactories(IDocumentType docType) {
        if (this.documentEncryptorFactories == null) {
            this.documentEncryptorFactories = Outlet.get().lookupFactories(IDocumentEncryptor.class);
        }
        ArrayList<IDocumentEncryptorFactory> myEncryptorFactories = new ArrayList<IDocumentEncryptorFactory>();
        for (int i = 0; i < this.documentEncryptorFactories.length; ++i) {
            IDocumentEncryptorFactory encryptorFactory = (IDocumentEncryptorFactory)this.documentEncryptorFactories[i];
            if (!this.supportsDocType(encryptorFactory, docType)) continue;
            myEncryptorFactories.add(encryptorFactory);
        }
        return myEncryptorFactories.toArray(new IFactory[myEncryptorFactories.size()]);
    }

    public IFactory[] getEncryptorFactories() {
        if (this.encryptorFactories == null) {
            this.encryptorFactories = Outlet.get().lookupFactories(IRecipientProvider.class);
        }
        return this.encryptorFactories;
    }

    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return PREFERENCES_NAME;
    }

    public boolean isAutoSaveDocument() {
        return this.getPreferences().getBoolean(PREF_AUTO_SAVE_DOCUMENTS, false);
    }

    protected void preferencesInit(IPreferences preferences) {
        preferences.put(PREF_AUTO_SAVE_DOCUMENTS, false);
    }

    public void preferencesRestore() {
    }

    public void preferencesStore() {
    }

    public void setAutoSaveDocument(boolean autoSave) {
        this.getPreferences().put(PREF_AUTO_SAVE_DOCUMENTS, autoSave);
    }

    protected boolean supportsDocType(IDocumentEncryptorFactory encryptorFactory, IDocumentType docType) {
        IDocumentType[] supportedDocTypes = encryptorFactory.getSupportedDocumentTypes();
        if (supportedDocTypes == null) {
            return true;
        }
        for (IDocumentType supportedDocType : supportedDocTypes) {
            if (!supportedDocType.getId().equals(docType.getId())) continue;
            return true;
        }
        return false;
    }
}

