/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.signature;

import de.intarsys.security.processor.signature.SignatureLocatorCreationStrategy;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.string.StringTools;

public class AttachmentLocatorStrategy
extends SignatureLocatorCreationStrategy {
    private boolean replaceExtension = false;
    private String extension;
    private boolean append = false;
    private boolean overwrite = false;

    public static final AttachmentLocatorStrategy create(IArgs args) {
        AttachmentLocatorStrategy strategy = new AttachmentLocatorStrategy();
        strategy.setAppend(AttachmentLocatorStrategy.isAppend(args));
        strategy.setOverwrite(AttachmentLocatorStrategy.isOverwrite(args));
        strategy.setReplaceExtension(AttachmentLocatorStrategy.isReplaceExtension(args));
        strategy.setExtension(AttachmentLocatorStrategy.getLocatorExtension(args, null));
        return strategy;
    }

    public static String getLocatorExtension(IArgs args, String defaultValue) {
        String extension = ArgTools.getString((IArgs)args, (String)"locatorExtension", null);
        if (!StringTools.isEmpty((String)extension)) {
            return extension;
        }
        return defaultValue;
    }

    public static boolean isAppend(IArgs args) {
        return ArgTools.getBoolStrict((IArgs)args, (String)"append", (boolean)true);
    }

    public static boolean isOverwrite(IArgs args) {
        return ArgTools.getBoolStrict((IArgs)args, (String)"overwrite", (boolean)false);
    }

    public static boolean isReplaceExtension(IArgs args) {
        return ArgTools.getBoolStrict((IArgs)args, (String)"replaceExtension", (boolean)false);
    }

    @Override
    protected ILocator createChild(ILocator target, ILocator source) {
        String tempName = this.createDefaultName(source);
        return this.createChild(target, tempName);
    }

    protected ILocator createChild(ILocator target, String tempName) {
        if (target == null) {
            return new ByteArrayLocator(null, tempName);
        }
        return target.getChild(tempName);
    }

    protected String createDefaultName(ILocator source) {
        if (source == null) {
            return "doc." + this.getExtension();
        }
        Object tempName = source.getName();
        tempName = this.isReplaceExtension() ? FileTools.replaceExtension((String)tempName, (String)this.getExtension()) : (String)tempName + "." + this.getExtension();
        return tempName;
    }

    @Override
    protected ILocator createTarget(ILocator source) {
        String tempName = this.createDefaultName(source);
        ILocator tempLocator = null;
        if (source != null) {
            tempLocator = source.getParent();
        }
        return this.createChild(tempLocator, tempName);
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean isAppend() {
        return this.append;
    }

    @Override
    protected boolean isCreateUnique() {
        return !this.isAppend() && !this.isOverwrite();
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isReplaceExtension() {
        return this.replaceExtension;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setReplaceExtension(boolean replaceExtension) {
        this.replaceExtension = replaceExtension;
    }
}

