/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.signature;

import de.intarsys.processor.decorate.CommonPreprocessor;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.processor.ISignerPreprocessor;
import de.intarsys.security.processor.signature.CertificateValidationException;
import de.intarsys.security.processor.signature.PACKAGE;
import de.intarsys.security.processor.validation.OCSPValidatorFactory;
import de.intarsys.security.validation.IVSOCSP;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;

public class CertificateOCSPPreprocessor
extends CommonPreprocessor
implements ISignerPreprocessor {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public CertificateOCSPPreprocessor(IFactory factory) {
        super(factory);
    }

    protected void basicRun() throws Exception {
        IX509PublicKeyCertificate[] certs = this.getBaseProcessor().getCertificatePath();
        IX509PublicKeyCertificate certificate = certs == null || certs.length == 0 ? null : certs[0];
        Args ocspValidatorArgs = Args.create();
        ocspValidatorArgs.put("certificate", (Object)certificate);
        IVSOCSP state = (IVSOCSP)FunctorTools.perform((Object)OCSPValidatorFactory.ID, (IArgs)ocspValidatorArgs);
        if (state.isUndefined()) {
            throw new CertificateValidationException(Msg.getString("CertificateOCSPPreprocessor.ErrorSignerCertificateUndefined", new Object[0]));
        }
        if (state.isUnknown()) {
            throw new CertificateValidationException(Msg.getString("CertificateOCSPPreprocessor.ErrorSignerCertificateUnknown", new Object[0]));
        }
        if (state.isInvalid()) {
            throw new CertificateValidationException(Msg.getString("CertificateOCSPPreprocessor.ErrorSignerCertificateRevoked", new Object[0]));
        }
        this.ok();
    }

    public ISigner getBaseProcessor() {
        return (ISigner)super.getBaseProcessor();
    }
}

