/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.signature;

import de.intarsys.processor.decorate.CommonPreprocessor;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.common.CertificatePeriodValidator;
import de.intarsys.security.device.processor.ISignerPreprocessor;
import de.intarsys.security.processor.signature.CertificateValidationException;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.validation.IValidationResult;
import de.intarsys.tools.validation.ValidationTools;

public class CertificateValidityPreprocessor
extends CommonPreprocessor
implements ISignerPreprocessor {
    public CertificateValidityPreprocessor(IFactory factory) {
        super(factory);
    }

    protected void basicRun() throws Exception {
        CertificatePeriodValidator validator;
        IValidationResult result;
        IX509PublicKeyCertificate certificate;
        IX509PublicKeyCertificate[] certs = this.getBaseProcessor().getCertificatePath();
        IX509PublicKeyCertificate iX509PublicKeyCertificate = certificate = certs == null || certs.length == 0 ? null : certs[0];
        if (certificate != null && (result = (validator = new CertificatePeriodValidator()).validate((Object)certificate)).hasError()) {
            String msg = ValidationTools.getSummary((IValidationResult)result, (int)30);
            throw new CertificateValidationException(msg);
        }
        this.ok();
    }

    public ISigner getBaseProcessor() {
        return (ISigner)super.getBaseProcessor();
    }
}

