/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.signature;

import de.intarsys.document.model.IDocument;
import de.intarsys.processor.document.common.CommonDocumentProcessor;
import de.intarsys.security.algorithm.common.AlgorithmTools;
import de.intarsys.security.app.validation.commonpki.qes.CommonPKIProfile;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.digest.DigestTools;
import de.intarsys.security.document.validation.ISignedDocument;
import de.intarsys.security.document.validation.SignedDocument;
import de.intarsys.security.processor.signature.DocumentSignerException;
import de.intarsys.security.processor.signature.IDocumentSigner;
import de.intarsys.security.processor.signature.PACKAGE;
import de.intarsys.security.processor.signature.SignatureEnvironment;
import de.intarsys.security.processor.signature.SignatureLocatorCreationStrategy;
import de.intarsys.security.processor.signature.SignedDocManipulationException;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.tools.attachment.AttachmentTools;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IConversationSupport;
import de.intarsys.tools.conversation.driver.ConversationDriver;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.LicenseEnvironment;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.locator.trusted.ITrustedLocator;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.validation.IValidationResult;
import de.intarsys.tools.validation.ValidationTools;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonDocumentSigner
extends CommonDocumentProcessor
implements IDocumentSigner,
IConversationSupport<ISignatureContainer> {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(CommonDocumentSigner.class);
    public static final Collection<String> DIGEST_ALGORITHMS_ALL = Arrays.asList("SHA-1", "SHA-256", "SHA-384", "SHA-512", "RIPEMD160", "RIPEMD256");
    private Set<IX509AttributeCertificate> attributeCertificates;
    private boolean conversationRequested;
    private IConversation<ISignatureContainer> conversation;

    public CommonDocumentSigner(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    protected IConversation<Void> basicPrepare() {
        return Conversation.completed(null);
    }

    protected final void basicRun() throws Exception {
        this.conversation = this.createConversation();
        this.conversation.thenAccept(signature -> {
            this.setResult(signature);
            this.ok();
        }).exceptionally(ex -> {
            this.handleThrowable((Throwable)ex);
            return null;
        });
        if (!this.conversationRequested) {
            ConversationDriver.get().get(this.conversation);
        }
    }

    protected abstract IConversation<ISignatureContainer> basicSign(IDigester var1);

    protected void checkSignedDocumentConsistency() throws SignedDocManipulationException {
        ILocator docLocator = this.getDocument().getLocator();
        if (docLocator instanceof ITrustedLocator) {
            try {
                ((ITrustedLocator)docLocator).checkpoint();
            }
            catch (IOException e) {
                String msg = this.getSignedDocManipulationMessage();
                throw new SignedDocManipulationException(msg);
            }
        }
    }

    protected final IConversation<ISignatureContainer> createConversation() {
        return this.basicPrepare().thenAccept(ignore -> {
            if (this.getDocument().isChanged()) {
                DocumentSignerException e = new DocumentSignerException(Msg.getString("CommonDocumentSigner.ExUnsavedChanges", new Object[0]));
                throw new CompletionException(e);
            }
            if (!this.isAuthorized()) {
                LicenseException e = new LicenseException(Msg.getString("CommonDocumentSigner.ExLicense", new Object[0]));
                throw new CompletionException((Throwable)e);
            }
        }).thenCompose(ignore -> {
            IDigester digester = this.createDigester();
            String hashAlgorithmName = digester.getAlgorithmName();
            IValidationResult result = AlgorithmTools.checkForWeakHashAlgorithm((CommonPKIProfile)SignatureEnvironment.get().getPolicy(), (String)hashAlgorithmName);
            if (!result.getNotices().isEmpty()) {
                Log.warn(ValidationTools.getSummary((IValidationResult)result));
            }
            Log.trace("basicSign({})", (Object)this.getShortName());
            return this.basicSign(digester);
        }).thenApply(signature -> {
            ISignedDocument signedDoc;
            if (signature != null && signature.isDetached()) {
                AttachmentTools.addAttachment((String)signature.getLocator().getPath(), (Object)signature.getLocator());
            }
            if ((signedDoc = SignedDocument.lookupSignedDocument((IAttributeSupport)this.getDocument())) != null) {
                signedDoc.addSignatureContainer(signature);
            }
            return signature;
        });
    }

    protected ILocator createDestinationLocator(ILocator source) throws DocumentSignerException {
        ILocator destination = this.getLocatorCreationStrategy().createLocator(this.getLocator(), source);
        if (destination.isReadOnly()) {
            String msg = Msg.getString("CommonDocumentSigner.ExFileReadOnly", new Object[]{destination.getPath()});
            throw new DocumentSignerException(msg);
        }
        return destination;
    }

    protected IDigester createDigester() {
        return DigestTools.getDigesterOrSha1((IArgs)this.getArgs(), (String)this.getPreferredHashAlgorithmName(), this.getSupportedHashAlgorithmNames());
    }

    public Set<IX509AttributeCertificate> getAttributeCertificates() {
        return this.attributeCertificates;
    }

    public IConversation<ISignatureContainer> getConversation() {
        this.conversationRequested = true;
        try {
            this.start();
            return this.conversation;
        }
        catch (Exception e) {
            return Conversation.failed((Throwable)e);
        }
    }

    protected ILocator getLocator() {
        return ArgTools.getLocator((IArgs)this.getArgs(), (String)"locator", null, (ILocatorFactory)LocatorFactory.get());
    }

    protected abstract SignatureLocatorCreationStrategy getLocatorCreationStrategy();

    protected String getPreferredHashAlgorithmName() {
        return "SHA-256";
    }

    protected abstract String getSignedDocManipulationMessage();

    protected Collection<String> getSupportedHashAlgorithmNames() {
        return DIGEST_ALGORITHMS_ALL;
    }

    protected Object getTimestampDevice() throws ObjectCreationException {
        Object value = this.getArgs().get("timestampDevice");
        if (value == null) {
            value = ArgTools.getString((IArgs)this.getArgs(), (String)"timestampServiceName", null);
        }
        return value;
    }

    protected boolean isAuthorized() {
        return LicenseEnvironment.get().isAuthorizedProfessional();
    }

    public void setAttributeCertificates(Set<IX509AttributeCertificate> attributeCertificates) {
        this.attributeCertificates = attributeCertificates;
    }
}

